/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Mercator
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Mercator";
    private static final double DEFAULT_MAXLAT = 80.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.log(Math.tan(1.4835298641951802));
    public double maxLat_ = 80.0;

    public Mercator(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mercator(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Mercator(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.addParameter(new DoubleParameter("Max. Latitude", "\u00b0", 80.0, 45.0, 90.0, true, false));
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setMaximumLatitude(((DoubleParameter)p).getValue());
    }

    public void setMaximumLatitude(double lat) {
        this.maxLat_ = lat;
        this.autoscale();
    }

    protected void prepareScaling() {
        double yMaxOverR = Math.log(Math.tan((45.0 + 0.5 * this.maxLat_) * (Math.PI / 180)));
        this.setSizeFactors(Math.PI, yMaxOverR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > this.maxLat_) {
            return null;
        }
        double x = this.lon2LambdaRad(lon);
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + Mercator.toRadians(lat))));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(Math.exp(y * this.oneOverRS_)) - 1.5707963267948966;
        if (Math.abs(Mercator.toDegrees(phiRad)) > this.maxLat_) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Mercator.toDegrees(phiRad);
        double lambda = Mercator.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phi;
        for (int iy = 0; iy < this.yMax_ && !((phi = (2.0 * Math.atan(Math.exp((y = (double)iy + 0.5) * this.oneOverRS_)) - 1.5707963267948966) * 57.29577951308232) > this.maxLat_); ++iy) {
            double x;
            double lambdaRad;
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Mercator.toDegrees(lambdaRad), phi);
            }
        }
    }
}

