/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeThomasSine1
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "McBryde-Thomas Sine #1";
    private static final double TERMQ = 1.36508592;
    private static final double TERMP = 1.48875143;
    private static final double ONE_OVER_Q = 0.7325546219098062;
    private static final double Q_OVER_P = 0.9169334064048557;
    private static final double P_OVER_Q = 1.0905917409213333;
    private static final double WIDTH_FACTOR = 2.8806312533925587;
    private static final double HEIGHT_FACTOR = 1.48875143 * Math.sin(1.150694109272548);

    public McBrydeThomasSine1(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeThomasSine1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeThomasSine1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.8806312533925587, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = McBrydeThomasSine1.toRadians(lat);
        double phiOverQ = phiRad * 0.7325546219098062;
        double x = 0.9169334064048557 * this.lon2LambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = 1.48875143 * Math.sin(phiOverQ);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double oneOverPRS = this.oneOverRS_ / 1.48875143;
        double pOverQRS = 1.0905917409213333 * this.oneOverRS_;
        double phiRad = 1.36508592 * Math.asin(y * oneOverPRS);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double d = lambdaRad = phiRad == 0.0 ? x * pOverQRS * 0.7325546219098062 : x * pOverQRS * Math.cos(phiRad * 0.7325546219098062) / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = McBrydeThomasSine1.toDegrees(phiRad);
        double lambda = McBrydeThomasSine1.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double oneOverPRS = this.oneOverRS_ / 1.48875143;
        double pOverQRS = 1.0905917409213333 * this.oneOverRS_;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 1.36508592 * Math.asin((y = (double)iy + 0.5) * oneOverPRS)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = McBrydeThomasSine1.toDegrees(phiRad);
            double xFactor = pOverQRS * Math.cos(phiRad * 0.7325546219098062) / Math.cos(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, McBrydeThomasSine1.toDegrees(lambdaRad), phi);
            }
        }
    }
}

