/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeS3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde S3";
    public static final int PROPERTIES = 786436;
    private static final double JOIN_LAT = 55.85;
    private static final double YSHIFT = 0.069065;
    private static final double TERMC = Math.sqrt(0.840148730267336);
    private static final double TERMD = 1.7853981633974483;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = TERMC * 1.5707963267948966 - 0.069065;
    private double joinY_;
    private double threeOver2RSC_;

    public McBrydeS3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeS3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeS3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 786436, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.threeOver2RSC_ = 1.5 * this.oneOverRS_ / TERMC;
        Point2D.Double joinPt = this.transformLL2XYIgnoreMargins(0.0, 55.85);
        this.joinY_ = (double)this.outCenterY_ - joinPt.y;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = McBrydeS3.toRadians(lat);
        double thetaRad = 0.0;
        if (Math.abs(lat) > 55.85) {
            double phiFactor = 1.7853981633974483 * Math.sin(McBrydeS3.toRadians(lat));
            thetaRad = McBrydeS3.toRadians(lat);
            for (int iter = 0; iter < 25; ++iter) {
                double func = 0.5 * thetaRad + Math.sin(thetaRad) - phiFactor;
                double dfunc = 0.5 + Math.cos(thetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = TERMC * thetaRad;
            y = lat > 0.0 ? (y -= 0.069065) : (y += 0.069065);
        } else {
            y = phiRad;
        }
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon);
            x = Math.abs(lat) > 55.85 ? (x *= TERMC * (0.5 + Math.cos(thetaRad)) / 1.5) : (x *= Math.cos(phiRad));
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = McBrydeS3.normalizeLon180(lon) - clon;
            if (McBrydeS3.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon);
            x = Math.abs(lat) > 55.85 ? TERMC * (0.5 + Math.cos(thetaRad)) / 1.5 : Math.cos(phiRad);
            x = cx + McBrydeS3.toRadians(dlon) * x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinY_) {
            double sinTheta;
            double yOverRS = Math.abs(y) * this.oneOverRS_ + 0.069065;
            double thetaRad = yOverRS / TERMC;
            phiRad = Math.asin((0.5 * thetaRad + (sinTheta = Math.sin(thetaRad))) / 1.7853981633974483);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = this.threeOver2RSC_ / (0.5 + Math.cos(thetaRad));
        } else {
            phiRad = y * this.oneOverRS_;
            xFactor = this.oneOverRS_ / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = McBrydeS3.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double xFactor;
            double phiRad;
            double y = (double)iy + 0.5;
            if (Math.abs(y) > this.joinY_) {
                double yOverRS = y * this.oneOverRS_;
                yOverRS = y > 0.0 ? (yOverRS += 0.069065) : (yOverRS -= 0.069065);
                double thetaRad = yOverRS / TERMC;
                double sinTheta = Math.sin(thetaRad);
                phiRad = Math.asin((0.5 * thetaRad + sinTheta) / 1.7853981633974483);
                if (phiRad > 1.5707963267948966) break;
                xFactor = this.threeOver2RSC_ / (0.5 + Math.cos(thetaRad));
            } else {
                phiRad = y * this.oneOverRS_;
                xFactor = this.oneOverRS_ / Math.cos(phiRad);
            }
            double phi = McBrydeS3.toDegrees(phiRad);
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

