/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeS2
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde S2";
    public static final int PROPERTIES = 786436;
    private static final double JOIN_LAT = 49.2666666667;
    private static final double YSHIFT = 0.084398;
    private static final double TWO_PLUS_PI = 5.141592653589793;
    private static final double TERM1 = Math.sqrt(5.141592653589793);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TWO_OVER_TERM1 = 2.0 * ONE_OVER_TERM1;
    private static final double TERM3 = 0.5 * TWO_OVER_TERM1 * TWO_OVER_TERM1;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = ONE_OVER_TERM1 * Math.PI - 0.084398;
    private double joinY_;

    public McBrydeS2(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeS2(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeS2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 786436, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        Point2D.Double joinPt = this.transformLL2XYIgnoreMargins(0.0, 49.2666666667);
        this.joinY_ = (double)this.outCenterY_ - joinPt.y;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double thetaRad = 0.0;
        double phiRad = McBrydeS2.toRadians(lat);
        if (Math.abs(lat) > 49.2666666667) {
            double phiFactor = 2.5707963267948966 * Math.sin(McBrydeS2.toRadians(lat));
            thetaRad = McBrydeS2.toRadians(lat);
            for (int iter = 0; iter < 25; ++iter) {
                double func = thetaRad + Math.sin(thetaRad) - phiFactor;
                double dfunc = 1.0 + Math.cos(thetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = 2.0 * thetaRad * ONE_OVER_TERM1;
            y = lat > 0.0 ? (y -= 0.084398) : (y += 0.084398);
        } else {
            y = phiRad;
        }
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon);
            x = Math.abs(lat) > 49.2666666667 ? (x *= (1.0 + Math.cos(thetaRad)) * ONE_OVER_TERM1) : (x *= Math.cos(phiRad));
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = McBrydeS2.normalizeLon180(lon) - clon;
            if (McBrydeS2.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon);
            x = Math.abs(lat) > 49.2666666667 ? (1.0 + Math.cos(thetaRad)) * ONE_OVER_TERM1 : Math.cos(phiRad);
            x = cx + McBrydeS2.toRadians(dlon) * x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinY_) {
            double sinTheta;
            double yOverRS = Math.abs(y) * this.oneOverRS_ + 0.084398;
            double thetaRad = yOverRS / TWO_OVER_TERM1;
            phiRad = Math.asin((thetaRad + (sinTheta = Math.sin(thetaRad))) * TERM3);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = 2.0 * this.oneOverRS_ / (TWO_OVER_TERM1 * (1.0 + Math.cos(thetaRad)));
        } else {
            phiRad = y * this.oneOverRS_;
            xFactor = this.oneOverRS_ / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = McBrydeS2.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        double twoOverRS = 2.0 * this.oneOverRS_;
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double xFactor;
            double phiRad;
            double y = (double)iy + 0.5;
            if (Math.abs(y) > this.joinY_) {
                double yOverRS = y * this.oneOverRS_;
                yOverRS = y > 0.0 ? (yOverRS += 0.084398) : (yOverRS -= 0.084398);
                double thetaRad = yOverRS / TWO_OVER_TERM1;
                double sinTheta = Math.sin(thetaRad);
                phiRad = Math.asin((thetaRad + sinTheta) * TERM3);
                if (phiRad > 1.5707963267948966) break;
                xFactor = twoOverRS / (TWO_OVER_TERM1 * (1.0 + Math.cos(thetaRad)));
            } else {
                phiRad = y * this.oneOverRS_;
                xFactor = this.oneOverRS_ / Math.cos(phiRad);
            }
            double phi = McBrydeS2.toDegrees(phiRad);
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

