/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeQ3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde Q3";
    public static final int PROPERTIES = 786436;
    private static final double JOIN_LAT = 52.15;
    private static final double YSHIFT = 0.042686;
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double HALF_TWO_PLUS_SQRT2 = 1.7071067811865475;
    private static final double FPQTERM1 = 2.0 * Math.sqrt(0.8786796564403575);
    private static final double FPQTERM2 = Math.sqrt(10.242640687119286);
    private static final double ONE_OVER_FPQTERM1 = 1.0 / FPQTERM1;
    private static final double ONE_OVER_FPQTERM2 = 1.0 / FPQTERM2;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = FPQTERM1 / 1.4142135623730951 - 0.042686;
    private double joinY_;

    public McBrydeQ3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeQ3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeQ3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 786436, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        Point2D.Double joinPt = this.transformLL2XYIgnoreMargins(0.0, 52.15);
        this.joinY_ = (double)this.outCenterY_ - joinPt.y;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = McBrydeQ3.toRadians(lat);
        double thetaRad = 0.0;
        if (Math.abs(lat) > 52.15) {
            double phiTerm = 1.7071067811865475 * Math.sin(phiRad);
            thetaRad = phiRad;
            for (int iter = 0; iter < 25; ++iter) {
                double func = Math.sin(0.5 * thetaRad) + Math.sin(thetaRad) - phiTerm;
                double dfunc = 0.5 * Math.cos(0.5 * thetaRad) + Math.cos(thetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = FPQTERM1 * Math.sin(0.5 * thetaRad);
            y = lat > 0.0 ? (y -= 0.042686) : (y += 0.042686);
        } else {
            y = 2.0 * Math.sin(0.5 * phiRad);
        }
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon);
            x = Math.abs(lat) > 52.15 ? (x *= (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_FPQTERM2) : (x *= Math.cos(phiRad) / Math.cos(0.5 * phiRad));
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = McBrydeQ3.normalizeLon180(lon) - clon;
            if (McBrydeQ3.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon);
            x = Math.abs(lat) > 52.15 ? (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_FPQTERM2 : Math.cos(phiRad) / Math.cos(0.5 * phiRad);
            x = cx + McBrydeQ3.toRadians(dlon) * x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinY_) {
            double yOverRS = Math.abs(y) * this.oneOverRS_ + 0.042686;
            double thetaRad = 2.0 * Math.asin(yOverRS * ONE_OVER_FPQTERM1);
            phiRad = Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / 3.414213562373095);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = this.oneOverRS_ * FPQTERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
        } else {
            phiRad = 2.0 * Math.asin(y * 0.5 * this.oneOverRS_);
            xFactor = this.oneOverRS_ * Math.cos(0.5 * phiRad) / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = McBrydeQ3.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double xFactor;
            double phiRad;
            double y = (double)iy + 0.5;
            if (Math.abs(y) > this.joinY_) {
                double yOverRS = y * this.oneOverRS_;
                yOverRS = y > 0.0 ? (yOverRS += 0.042686) : (yOverRS -= 0.042686);
                double thetaRad = 2.0 * Math.asin(yOverRS * ONE_OVER_FPQTERM1);
                phiRad = Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / 3.414213562373095);
                if (phiRad > 1.5707963267948966) break;
                xFactor = this.oneOverRS_ * FPQTERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
            } else {
                phiRad = 2.0 * Math.asin(y * 0.5 * this.oneOverRS_);
                xFactor = this.oneOverRS_ * Math.cos(0.5 * phiRad) / Math.cos(phiRad);
            }
            double phi = McBrydeQ3.toDegrees(phiRad);
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

