/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeP3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde P3";
    public static final int PROPERTIES = 786436;
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double SQRT_PI = Math.sqrt(Math.PI);
    private static final double JOIN_LAT = 49.3393888889;
    private static final double YSHIFT = 0.035509;
    private static final double SQRT3PI = SQRT3 * SQRT_PI;
    private static final double SQRT3OVERPI = SQRT3 / SQRT_PI;
    private static final double SQRT_PIOVER3 = SQRT_PI / SQRT3;
    private static final double THREE_SQRT6 = 3.0 * Math.sqrt(6.0);
    private static final double SQRT_6OVER7 = Math.sqrt(0.8571428571428571);
    private static final double SQRT_7OVER6 = 1.0 / SQRT_6OVER7;
    private static final double NINE_OVER_SQRT7 = 9.0 / Math.sqrt(7.0);
    private static final double WIDTH_FACTOR = SQRT3PI;
    private static final double HEIGHT_FACTOR = NINE_OVER_SQRT7 * Math.sin(Math.asin(7.0 / THREE_SQRT6) / 3.0) - 0.035509;
    private double joinY_;
    private double rSSqrt3OverPi_;
    private double oneOverRSSqrt3Pi_;
    private double sqrt7Over6OverRs_;
    private double xFactor0_;

    public McBrydeP3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeP3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeP3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 786436, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.rSSqrt3OverPi_ = this.rS_ * SQRT3OVERPI;
        this.oneOverRSSqrt3Pi_ = 1.0 / (this.rS_ * SQRT3PI);
        this.sqrt7Over6OverRs_ = SQRT_7OVER6 * this.oneOverRS_;
        this.xFactor0_ = 1.0 / this.rSSqrt3OverPi_;
        Point2D.Double joinPt = this.transformLL2XYIgnoreMargins(0.0, 49.3393888889);
        this.joinY_ = (double)this.outCenterY_ - joinPt.y;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double thetaRad = 0.0;
        double phiRadOver3 = 0.0;
        if (Math.abs(lat) > 49.3393888889) {
            thetaRad = Math.asin(7.0 * Math.sin(McBrydeP3.toRadians(lat)) / THREE_SQRT6);
            y = NINE_OVER_SQRT7 * Math.sin(thetaRad / 3.0);
            y = lat > 0.0 ? (y -= 0.035509) : (y += 0.035509);
        } else {
            phiRadOver3 = McBrydeP3.toRadians(lat) / 3.0;
            y = SQRT3PI * Math.sin(phiRadOver3);
        }
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon);
            x = Math.abs(lat) > 49.3393888889 ? (x *= SQRT_6OVER7 * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0)) : (x *= SQRT3OVERPI * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0));
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = McBrydeP3.normalizeLon180(lon) - clon;
            if (McBrydeP3.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon) * SQRT3OVERPI;
            x = Math.abs(lat) > 49.3393888889 ? SQRT_6OVER7 * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0) : SQRT3OVERPI * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
            x = cx + McBrydeP3.toRadians(dlon) * x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinY_) {
            double yOverRS = Math.abs(y) * this.oneOverRS_ + 0.035509;
            double thetaRad = 3.0 * Math.asin(yOverRS / NINE_OVER_SQRT7);
            double sinTheta = Math.sin(thetaRad);
            phiRad = Math.asin(sinTheta * THREE_SQRT6 / 7.0);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = this.sqrt7Over6OverRs_ / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
        } else {
            phiRad = 3.0 * Math.asin(y * this.oneOverRSSqrt3Pi_);
            xFactor = 1.0 / (this.rSSqrt3OverPi_ * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
        }
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = McBrydeP3.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double xFactor;
            double phiRad;
            double y = (double)iy + 0.5;
            if (Math.abs(y) > this.joinY_) {
                double yOverRS = y * this.oneOverRS_;
                yOverRS = y > 0.0 ? (yOverRS += 0.035509) : (yOverRS -= 0.035509);
                double thetaRad = 3.0 * Math.asin(yOverRS / NINE_OVER_SQRT7);
                double sinTheta = Math.sin(thetaRad);
                phiRad = Math.asin(sinTheta * THREE_SQRT6 / 7.0);
                if (phiRad > 1.5707963267948966) continue;
                xFactor = this.sqrt7Over6OverRs_ / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
            } else {
                phiRad = 3.0 * Math.asin(y * this.oneOverRSSqrt3Pi_);
                xFactor = 1.0 / (this.rSSqrt3OverPi_ * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
            }
            double phi = McBrydeP3.toDegrees(phiRad);
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

