/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Mayr
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Mayr";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double A1 = -0.08333333333333333;
    private static final double A2 = -0.0020833333333333333;
    private static final double A3 = -2.48015873015873E-5;
    private static final double A4 = -9.627838403880071E-5;
    private static final double A5 = -2.2815424833654E-5;

    public Mayr(int width, int height) {
        this(width, height, 0, 0);
    }

    public Mayr(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Mayr(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Mayr.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double phiRad6 = phiRad4 * phiRad2;
        double phiRad8 = phiRad4 * phiRad4;
        double phiRad10 = phiRad6 * phiRad4;
        double sqrtCosPhi = Math.sqrt(Math.cos(phiRad));
        double lambdaRad = this.lon2LambdaRad(lon);
        double x = lambdaRad * sqrtCosPhi;
        double y = phiRad * (1.0 + -0.08333333333333333 * phiRad2 + -0.0020833333333333333 * phiRad4 + -2.48015873015873E-5 * phiRad6 + -9.627838403880071E-5 * phiRad8 + -2.2815424833654E-5 * phiRad10);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double phiRad8 = phiRad4 * phiRad4;
            double phiRad10 = phiRad6 * phiRad4;
            double func = phiRad * (1.0 + -0.08333333333333333 * phiRad2 + -0.0020833333333333333 * phiRad4 + -2.48015873015873E-5 * phiRad6 + -9.627838403880071E-5 * phiRad8 + -2.2815424833654E-5 * phiRad10) - yOverRS;
            double dfunc = 1.0 + -0.25 * phiRad2 + -0.010416666666666666 * phiRad4 + -1.7361111111111112E-4 * phiRad6 + -8.665054563492064E-4 * phiRad8 + -2.5096967317019404E-4 * phiRad10;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
            ++iters;
        }
        if (Math.abs(lambdaRad = x * this.oneOverRS_ / Math.sqrt(Math.cos(phiRad))) > Math.PI) {
            return null;
        }
        double phi = Mayr.toDegrees(phiRad);
        double lambda = Mayr.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
            double x;
            double lambdaRad;
            double yOverRS = y * this.oneOverRS_;
            int iters = 0;
            for (int iter = 0; iter < 25; ++iter) {
                double phiRad2 = phiRad * phiRad;
                double phiRad4 = phiRad2 * phiRad2;
                double phiRad6 = phiRad4 * phiRad2;
                double phiRad8 = phiRad4 * phiRad4;
                double phiRad10 = phiRad6 * phiRad4;
                double func = phiRad * (1.0 + -0.08333333333333333 * phiRad2 + -0.0020833333333333333 * phiRad4 + -2.48015873015873E-5 * phiRad6 + -9.627838403880071E-5 * phiRad8 + -2.2815424833654E-5 * phiRad10) - yOverRS;
                double dfunc = 1.0 + -0.25 * phiRad2 + -0.010416666666666666 * phiRad4 + -1.7361111111111112E-4 * phiRad6 + -8.665054563492064E-4 * phiRad8 + -2.5096967317019404E-4 * phiRad10;
                double dphiRad = -func / dfunc;
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
                ++iters;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = Mayr.toDegrees(phiRad);
            double xfactor = this.oneOverRS_ / Math.sqrt(Math.cos(phiRad));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xfactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Mayr.toDegrees(lambdaRad), phi);
            }
        }
    }
}

