/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class MTFlatPolarSinusoidal
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas Flat-Polar Sinusoidal";
    private static final double TERM1 = Math.sqrt(1.1902654422649654);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TERM2 = 0.5600991535115574;
    private static final double ONE_OVER_TERM2 = 1.7853981633974483;
    private static final double WIDTH_FACTOR = Math.PI * ONE_OVER_TERM1;
    private static final double HEIGHT_FACTOR = 1.5707963267948966 * ONE_OVER_TERM1;
    private double xFactor0_;

    public MTFlatPolarSinusoidal(int width, int height) {
        this(width, height, 0, 0);
    }

    public MTFlatPolarSinusoidal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MTFlatPolarSinusoidal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 524292, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.xFactor0_ = this.oneOverRS_ * TERM1;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiTerm = 1.7853981633974483 * Math.sin(MTFlatPolarSinusoidal.toRadians(lat));
        double thetaRad = MTFlatPolarSinusoidal.toRadians(lat);
        for (int iter = 0; iter < 25; ++iter) {
            double func = 0.5 * thetaRad + Math.sin(thetaRad) - phiTerm;
            double dfunc = 0.5 + Math.cos(thetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = thetaRad * ONE_OVER_TERM1;
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon) * ONE_OVER_TERM1 * (0.5 + Math.cos(thetaRad)) / 1.5;
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = MTFlatPolarSinusoidal.normalizeLon180(lon) - clon;
            if (MTFlatPolarSinusoidal.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon) * ONE_OVER_TERM1;
            x = cx + MTFlatPolarSinusoidal.toRadians(dlon) * ONE_OVER_TERM1 * (0.5 + Math.cos(thetaRad)) / 1.5;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = y * this.oneOverRS_ * TERM1;
        double sinTheta = Math.sin(thetaRad);
        double phiRad = Math.asin((0.5 * thetaRad + sinTheta) * 0.5600991535115574);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = 1.5 * this.oneOverRS_ * TERM1 / (0.5 + Math.cos(thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = MTFlatPolarSinusoidal.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double thetaRad = yOverRS * TERM1;
            double sinTheta = Math.sin(thetaRad);
            double phiRad = Math.asin((0.5 * thetaRad + sinTheta) * 0.5600991535115574);
            if (phiRad < -1.5707963267948966) continue;
            if (phiRad > 1.5707963267948966) break;
            double phi = MTFlatPolarSinusoidal.toDegrees(phiRad);
            double xFactor = 1.5 * this.oneOverRS_ * TERM1 / (0.5 + Math.cos(thetaRad));
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

