/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class MTFlatPolarQuartic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas Flat-Polar Quartic";
    private static final double TWO_PLUS_SQRT2 = 3.414213562373095;
    private static final double HALF_TWO_PLUS_SQRT2 = 1.7071067811865475;
    private static final double TERM1 = 2.0 * Math.sqrt(0.8786796564403575);
    private static final double TERM2 = Math.sqrt(10.242640687119286);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double ONE_OVER_TERM2 = 1.0 / TERM2;
    private static final double WIDTH_FACTOR = 1.5707963267948966 * TERM1;
    private static final double HEIGHT_FACTOR = TERM1 / 1.4142135623730951;
    private double xFactor0_;

    public MTFlatPolarQuartic(int width, int height) {
        this(width, height, 0, 0);
    }

    public MTFlatPolarQuartic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MTFlatPolarQuartic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 524292, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.xFactor0_ = this.oneOverRS_ * TERM2 / 3.0;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiTerm = 1.7071067811865475 * Math.sin(MTFlatPolarQuartic.toRadians(lat));
        double thetaRad = MTFlatPolarQuartic.toRadians(lat);
        for (int iter = 0; iter < 25; ++iter) {
            double func = Math.sin(0.5 * thetaRad) + Math.sin(thetaRad) - phiTerm;
            double dfunc = 0.5 * Math.cos(0.5 * thetaRad) + Math.cos(thetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = TERM1 * Math.sin(0.5 * thetaRad);
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon) * (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_TERM2;
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = MTFlatPolarQuartic.normalizeLon180(lon) - clon;
            if (MTFlatPolarQuartic.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon) * 3.0 * ONE_OVER_TERM2;
            x = cx + MTFlatPolarQuartic.toRadians(dlon) * (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_TERM2;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = 2.0 * Math.asin(y * this.oneOverRS_ * ONE_OVER_TERM1);
        double phiRad = Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / 3.414213562373095);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.oneOverRS_ * TERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = MTFlatPolarQuartic.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double thetaRad = 2.0 * Math.asin(yOverRS * ONE_OVER_TERM1);
            double phiRad = Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / 3.414213562373095);
            if (phiRad < -1.5707963267948966) continue;
            if (phiRad > 1.5707963267948966) break;
            double phi = MTFlatPolarQuartic.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ * TERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad));
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

