/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class MTFlatPolarParabolic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde-Thomas Flat-Polar Parabolic";
    private static final double TERM1 = 3.0 * Math.sqrt(6.0);
    private static final double SQRT_6OVER7 = Math.sqrt(0.8571428571428571);
    private static final double SQRT_7OVER6 = 1.0 / SQRT_6OVER7;
    private static final double TERM3 = 9.0 / Math.sqrt(7.0);
    private static final double ONE_OVER_TERM3 = 1.0 / TERM3;
    private static final double WIDTH_FACTOR = SQRT_6OVER7 * Math.PI;
    private static final double HEIGHT_FACTOR = TERM3 * Math.sin(Math.asin(7.0 / TERM1) / 3.0);
    private double xFactor0_;

    public MTFlatPolarParabolic(int width, int height) {
        this(width, height, 0, 0);
    }

    public MTFlatPolarParabolic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public MTFlatPolarParabolic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 524292, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    protected void finishScaling() {
        this.xFactor0_ = this.oneOverRS_ * SQRT_7OVER6;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double thetaRad = Math.asin(7.0 * Math.sin(MTFlatPolarParabolic.toRadians(lat)) / TERM1);
        double y = TERM3 * Math.sin(thetaRad / 3.0);
        if (!this.isShowingInterrupted()) {
            x = SQRT_6OVER7 * this.lon2LambdaRad(lon) * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = MTFlatPolarParabolic.normalizeLon180(lon) - clon;
            if (MTFlatPolarParabolic.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon) * SQRT_6OVER7;
            x = cx + MTFlatPolarParabolic.toRadians(dlon) * SQRT_6OVER7 * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = 3.0 * Math.asin(y * this.oneOverRS_ * ONE_OVER_TERM3);
        double sinTheta = Math.sin(thetaRad);
        double phiRad = Math.asin(sinTheta * TERM1 / 7.0);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.oneOverRS_ * SQRT_7OVER6 / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = MTFlatPolarParabolic.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double thetaRad = 3.0 * Math.asin(yOverRS * ONE_OVER_TERM3);
            double sinTheta = Math.sin(thetaRad);
            double phiRad = Math.asin(sinTheta * TERM1 / 7.0);
            if (phiRad < -1.5707963267948966) continue;
            if (phiRad > 1.5707963267948966) break;
            double phi = MTFlatPolarParabolic.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ * SQRT_7OVER6 / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

