/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ExtraParameter;

public class ListParameter
extends ExtraParameter {
    private Object[] choices_;
    private int index_;
    private int defaultIndex_;

    public ListParameter(String name, Object[] choices, int index) {
        super(name, "");
        this.choices_ = choices;
        this.defaultIndex_ = index;
        this.index_ = index;
        this.reset();
    }

    public Object[] getChoices() {
        return this.choices_;
    }

    public void reset() {
        this.setSelectedIndex(this.defaultIndex_);
    }

    public Object getDefault() {
        return this.choices_[this.defaultIndex_];
    }

    public Object getValue() {
        return this.choices_[this.index_];
    }

    public void setValue(String value) {
        for (int i = 0; i < this.choices_.length; ++i) {
            if (!this.choices_[i].toString().equalsIgnoreCase(value)) continue;
            this.index_ = i;
            break;
        }
        this.fireChange();
    }

    public int getSelectedIndex() {
        return this.index_;
    }

    public void setSelectedIndex(int index) throws IllegalArgumentException {
        if (this.index_ < 0 || this.index_ >= this.choices_.length) {
            throw new IllegalArgumentException("Choice out of range.");
        }
        this.index_ = index;
        this.fireChange();
    }

    public Object getDefaultObject() {
        return this.choices_[this.defaultIndex_];
    }

    public Object getValueObject() {
        return this.choices_[this.index_];
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        this.setValue(value.toString());
    }
}

