/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ConcavePoleProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Larrivee
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Larriv\u00e9e";
    public static final int PROPERTIES = 0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double HEIGHT_FACTOR = 1.5707963267948966 / (0.3535533905932738 * SQRT3);
    private static final double PI_OVER_SQRT2 = 2.221441469079183;

    public Larrivee(int width, int height) {
        this(width, height, 0, 0);
    }

    public Larrivee(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Larrivee(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = Larrivee.toRadians(lat);
        double x = 0.5 * lambdaRad * (1.0 + Math.sqrt(Math.cos(phiRad)));
        double y = phiRad / (Math.cos(0.5 * phiRad) * Math.cos(lambdaRad / 6.0));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double yOverRS = absY * this.oneOverRS_;
        double lambdaRad0 = 0.0;
        double phiRad0 = 0.0;
        if (yOverRS < 2.221441469079183) {
            phiRad0 = 1.5707963267948966 * (yOverRS / 2.221441469079183);
            lambdaRad0 = 1.0E-5;
        } else {
            phiRad0 = 1.5707763267948966;
            lambdaRad0 = 6.0 * Math.acos(2.221441469079183 / yOverRS);
            if (absX < this.rS_ * lambdaRad0 * 0.5) {
                return null;
            }
            lambdaRad0 += 1.0E-5;
        }
        double[] llRad = this.iterateRad(absX, absY, lambdaRad0, phiRad0);
        if (llRad == null) {
            return null;
        }
        if (llRad[1] > 1.5707963267948966) {
            return null;
        }
        double lambda = Larrivee.toDegrees(llRad[0]);
        double phi = Larrivee.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double lambdaRad = 0.0;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double[] llRad;
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            int minX = 0;
            if (yOverRS < 2.221441469079183) {
                phiRad = 1.5707963267948966 * (yOverRS / 2.221441469079183);
                lambdaRad = 1.0E-5;
            } else {
                phiRad = 1.5707763267948966;
                lambdaRad = 6.0 * Math.acos(2.221441469079183 / yOverRS);
                minX = (int)(this.rS_ * lambdaRad * 0.5) + 1;
                lambdaRad += 2.0E-5;
            }
            for (int ix = minX; ix < this.xMax_ && (llRad = this.iterateRad(x = (double)ix + 0.5, y, lambdaRad, phiRad)) != null; ++ix) {
                lambdaRad = llRad[0];
                phiRad = llRad[1];
                this.setQSymmetricPoints(ix, iy, Larrivee.toDegrees(lambdaRad), Larrivee.toDegrees(phiRad));
            }
        }
    }

    private double[] iterateRad(double x, double y, double lambdaRad0, double phiRad0) {
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        double f1 = 0.0;
        double f2 = 0.0;
        double df1dLambda = 0.0;
        double df1dPhi = 0.0;
        double df2dLambda = 0.0;
        double df2dPhi = 0.0;
        double denom = 0.0;
        double dphi = 0.0;
        double dlambda = 0.0;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRadOver2 = 0.5 * phiRad;
            double lambdaRadOver6 = lambdaRad / 6.0;
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double cosPhiOver2 = Math.cos(phiRadOver2);
            double sinPhiOver2 = Math.sin(phiRadOver2);
            double cosLambdaOver6 = Math.cos(lambdaRadOver6);
            double sinLambdaOver6 = Math.sin(lambdaRadOver6);
            double oneOverCosPhiOver2 = 1.0 / cosPhiOver2;
            double oneOverCosLambdaOver6 = 1.0 / cosLambdaOver6;
            double sqrtCosPhi = Math.sqrt(cosPhi);
            double onePlusSqrtCosPhi = 1.0 + sqrtCosPhi;
            f1 = 0.5 * lambdaRad * onePlusSqrtCosPhi - xOverRS;
            f2 = phiRad * oneOverCosPhiOver2 * oneOverCosLambdaOver6 - yOverRS;
            df1dPhi = -0.25 * lambdaRad * sinPhi / sqrtCosPhi;
            df1dLambda = 0.5 * onePlusSqrtCosPhi;
            df2dPhi = (1.0 + 0.5 * phiRad * sinPhiOver2 * oneOverCosPhiOver2) * oneOverCosPhiOver2 * oneOverCosLambdaOver6;
            df2dLambda = phiRad * oneOverCosPhiOver2 * (sinLambdaOver6 / 6.0) * oneOverCosLambdaOver6 * oneOverCosLambdaOver6;
            denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) break;
            ++iters;
        }
        if (iters >= 25) {
            return null;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

