/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ConicProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class LambertConformalConic
extends ConicProjection {
    public static final String PROJECTION_NAME = "Lambert Conformal Conic";
    public static final int PROPERTIES = 131080;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private double termN_;
    private double oneOverN_;
    private double termF_;
    private double rho0_;

    public LambertConformalConic(int width, int height) {
        this(width, height, 0, 0);
    }

    public LambertConformalConic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public LambertConformalConic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131080, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.autoscale();
    }

    protected void prepareScaling() {
        double phiCRad = LambertConformalConic.toRadians(this.phiC_);
        double phi1Rad = LambertConformalConic.toRadians(this.phi1_);
        double phi2Rad = LambertConformalConic.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        double tanTerm1 = Math.tan(0.7853981633974483 + 0.5 * phi1Rad);
        double tanTerm2 = Math.tan(0.7853981633974483 + 0.5 * phi2Rad);
        this.termN_ = this.phi1_ == this.phi2_ ? Math.sin(phi1Rad) : Math.log(cosPhi1 / cosPhi2) / Math.log(tanTerm2 / tanTerm1);
        this.oneOverN_ = 1.0 / this.termN_;
        this.termF_ = cosPhi1 * Math.pow(tanTerm1, this.termN_) * this.oneOverN_;
        this.rho0_ = this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiCRad), this.termN_);
        double dPhi = this.phiHeight_;
        double phiT = Math.min(90.0, this.phiC_ + 0.5 * dPhi);
        double phiB = Math.max(-90.0, this.phiC_ - 0.5 * dPhi);
        if (phiT > 89.9 && this.termN_ < 0.0) {
            phiT = 89.9;
        }
        if (phiB < -89.9 && this.termN_ > 0.0) {
            phiB = -89.9;
        }
        double phiTRad = LambertConformalConic.toRadians(phiT);
        double phiBRad = LambertConformalConic.toRadians(phiB);
        double lambdaRad1 = 0.0;
        double lambdaRad2 = 0.5 * LambertConformalConic.toRadians(dPhi);
        double rhoT = this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiTRad), this.termN_);
        double rhoB = this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiBRad), this.termN_);
        double theta1 = this.termN_ * 0.0;
        double theta2 = this.termN_ * lambdaRad2;
        double xT1 = rhoT * Math.sin(theta1);
        double xT2 = rhoT * Math.sin(theta2);
        double xB1 = rhoB * Math.sin(theta1);
        double xB2 = rhoB * Math.sin(theta2);
        double yT1 = this.rho0_ - rhoT * Math.cos(theta1);
        double yT2 = this.rho0_ - rhoT * Math.cos(theta2);
        double yB1 = this.rho0_ - rhoB * Math.cos(theta1);
        double yB2 = this.rho0_ - rhoB * Math.cos(theta2);
        double yT = yT2 > yB2 ? Math.max(yT1, yT2) : Math.max(yT1, yB2);
        double yB = yT2 > yB2 ? Math.min(yB1, yB2) : Math.min(yB1, yT2);
        double xMaxOverR = Math.max(xT2, xB2);
        double yMaxOverR = Math.max(Math.abs(yT), Math.abs(yB));
        this.setSizeFactors(xMaxOverR, yMaxOverR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = LambertConformalConic.toRadians(lat);
        if (lat == 90.0 && this.termN_ < 0.0 || lat == -90.0 && this.termN_ > 0.0) {
            return null;
        }
        double rho = Math.abs(lat) == 90.0 ? 0.0 : this.termF_ / Math.pow(Math.tan(0.7853981633974483 + 0.5 * phiRad), this.termN_);
        double thetaRad = this.termN_ * lambdaRad;
        double x = rho * Math.sin(thetaRad);
        double y = this.rho0_ - rho * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double rho0MinusYOverRS = this.rho0_ - yOverRS;
        double rho = Math.hypot(xOverRS, rho0MinusYOverRS);
        if (this.termN_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = 2.0 * (Math.atan(Math.pow(this.termF_ / rho, this.oneOverN_)) - 0.7853981633974483)) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0MinusYOverRS) : Math.atan2(xOverRS, rho0MinusYOverRS);
        double lambdaRad = thetaRad * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = LambertConformalConic.toDegrees(phiRad);
        double lambda = LambertConformalConic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double rho0MinusYOverRS = this.rho0_ - yOverRS;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double thetaRad;
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                double rho = Math.hypot(xOverRS, rho0MinusYOverRS);
                if (this.termN_ < 0.0) {
                    rho = -rho;
                }
                if (Math.abs(phiRad = 2.0 * (Math.atan(Math.pow(this.termF_ / rho, this.oneOverN_)) - 0.7853981633974483)) > 1.5707963267948966 || (lambdaRad = (thetaRad = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0MinusYOverRS) : Math.atan2(xOverRS, rho0MinusYOverRS)) * this.oneOverN_) > Math.PI) continue;
                this.setBiSymmetricPoints(ix, iy, LambertConformalConic.toDegrees(lambdaRad), LambertConformalConic.toDegrees(phiRad));
            }
        }
    }
}

