/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Kavraisky7
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Kavraisky VII";
    private static final double CSUBX = 0.5 * Math.sqrt(3.0);
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double THREE_OVER_PI = 0.954929658551372;
    private static final double THREE_OVER_PI2 = 0.3039635509270133;
    private static final double WIDTH_FACTOR = CSUBX * Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public Kavraisky7(int width, int height) {
        this(width, height, 0, 0);
    }

    public Kavraisky7(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Kavraisky7(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Kavraisky7.toRadians(lat);
        double x = CSUBX * this.lon2LambdaRad(lon) * Math.sqrt(1.0 - phiRad * phiRad * 0.3039635509270133);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * ONE_OVER_CSUBX * this.oneOverRS_ / Math.sqrt(1.0 - phiRad * phiRad * 0.3039635509270133);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Kavraisky7.toDegrees(phiRad);
        double lambda = Kavraisky7.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Kavraisky7.toDegrees(phiRad);
            double xFactor = ONE_OVER_CSUBX * this.oneOverRS_ / Math.sqrt(1.0 - phiRad * phiRad * 0.3039635509270133);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Kavraisky7.toDegrees(lambdaRad), phi);
            }
        }
    }
}

