/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Kavraisky5
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Kavraisky V";
    private static final double TERMQ = 0.6108652381980153 / Math.acos(0.9);
    private static final double Q_OVER_P = 0.9;
    private static final double P_OVER_Q = 1.1111111111111112;
    private static final double TERMP = TERMQ * 1.1111111111111112;
    private static final double WIDTH_FACTOR = 2.827433388230814;
    private static final double HEIGHT_FACTOR = TERMP * Math.sin(1.5707963267948966 / TERMQ);

    public Kavraisky5(int width, int height) {
        this(width, height, 0, 0);
    }

    public Kavraisky5(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Kavraisky5(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.827433388230814, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Kavraisky5.toRadians(lat);
        double phiOverQ = phiRad / TERMQ;
        double x = 0.9 * this.lon2LambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = TERMP * Math.sin(phiOverQ);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double oneOverPRS = this.oneOverRS_ / TERMP;
        double pOverQRS = 1.1111111111111112 * this.oneOverRS_;
        double phiRad = TERMQ * Math.asin(y * oneOverPRS);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * pOverQRS * Math.cos(phiRad / TERMQ) / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Kavraisky5.toDegrees(phiRad);
        double lambda = Kavraisky5.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double oneOverPRS = this.oneOverRS_ / TERMP;
        double pOverQRS = 1.1111111111111112 * this.oneOverRS_;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = TERMQ * Math.asin((y = (double)iy + 0.5) * oneOverPRS)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Kavraisky5.toDegrees(phiRad);
            double xFactor = pOverQRS * Math.cos(phiRad / TERMQ) / Math.cos(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Kavraisky5.toDegrees(lambdaRad), phi);
            }
        }
    }
}

