/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public abstract class InterruptedPseudocylindric
extends AbstractProjection {
    public static final int PROPERTIES = 524292;
    protected int formatIndex_ = 0;
    protected Interruption interruption_ = Interruption.values()[0];
    private ListParameter formatParam_;

    public InterruptedPseudocylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
        if (!this.isPseudocylindric() || !this.isInterrupted()) {
            throw new IllegalArgumentException("Subclassed projection does not have INTERRUPTED and PSEUDOCYLINDRIC properties.");
        }
        this.formatParam_ = new ListParameter("Format", (Object[])Interruption.values(), 0);
        this.addParameter(this.formatParam_);
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null || p == this.formatParam_) {
            this.formatIndex_ = this.formatParam_.getSelectedIndex();
            this.interruption_ = Interruption.values()[this.formatIndex_];
        }
        this.autoscale();
        if (!this.isRecenterableLon()) {
            this.setCenter(999.0, 0.0);
        }
    }

    public void setCenter(PointLL pt) {
        this.setCenter(pt.getLon(), pt.getLat());
    }

    public void setCenter(double lon, double lat) {
        if (this.isRecenterableLon() || this.interruption_ == null) {
            super.setCenter(lon, 0.0);
        } else {
            super.setCenter(this.interruption_.getCenterLongitude(), 0.0);
        }
    }

    public boolean isShowingInterrupted() {
        return this.interruption_ != Interruption.UNINTERRUPTED;
    }

    public boolean isRecenterableLon() {
        return this.interruption_ == Interruption.UNINTERRUPTED;
    }

    protected void drawBorderLines(Graphics2D g2d) {
        double jstep = 0.5;
        int jsteps = (int)(90.0 / jstep);
        if (this.isRecenterableLon()) {
            Bezier[] curves = new Bezier[2];
            double rightLon = this.lambdaC_ + 180.0 - 1.0E-5;
            double leftLon = this.lambdaC_ - 180.0 + 1.0E-5;
            int np = 105;
            double fact = 0.8571428571428571;
            Point2D.Double[] dotsE = new Point2D.Double[211];
            Point2D.Double[] dotsW = new Point2D.Double[211];
            for (int j = 0; j <= 105; ++j) {
                double jj = 0.8571428571428571 * (double)j;
                Point2D.Double dot = this.transformLL2XY(rightLon, jj);
                dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
                dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
                dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
                dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            }
            curves[0] = new Bezier(false, dotsE);
            curves[1] = new Bezier(false, dotsW);
            curves[0].paint(g2d);
            curves[1].paint(g2d);
            Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ + 180.0, 90.0);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ - 180.0, 90.0);
            if (dot1.x != dot2.x) {
                Path2D.Double polePath = new Path2D.Double();
                dot1 = this.transformLL2XY(leftLon, 89.99999);
                dot2 = this.transformLL2XY(rightLon, 89.99999);
                polePath.moveTo((float)dot1.x, (float)dot1.y);
                polePath.lineTo((float)dot2.x, (float)dot2.y);
                dot1 = this.transformLL2XY(leftLon, -89.99999);
                dot2 = this.transformLL2XY(rightLon, -89.99999);
                polePath.moveTo((float)dot1.x, (float)dot1.y);
                polePath.lineTo((float)dot2.x, (float)dot2.y);
                g2d.draw(polePath);
            }
        } else {
            PointLL[] rightPoints;
            PointLL[] leftPoints;
            int ii;
            double[][] north = this.interruption_.getGores()[0];
            double[][] south = this.interruption_.getGores()[1];
            boolean drawPoles = false;
            Point2D.Double dot1 = this.transformLL2XY(north[0][0], 90.0);
            Point2D.Double dot2 = this.transformLL2XY(north[0][2], 90.0);
            drawPoles = dot1.x != dot2.x;
            Path2D.Double polePath = new Path2D.Double();
            for (ii = 0; ii < north.length; ++ii) {
                leftPoints = new PointLL[jsteps + 1];
                rightPoints = new PointLL[jsteps + 1];
                for (int jj = 0; jj <= jsteps; ++jj) {
                    double lat = 0.0 + jstep * (double)jj;
                    if (jj == jsteps) {
                        lat = 89.99999;
                    }
                    leftPoints[jj] = new PointLL(north[ii][0] + 1.0E-5, lat);
                    rightPoints[jj] = new PointLL(north[ii][2] - 1.0E-5, lat);
                }
                this.drawBezier(g2d, this.translatePath(leftPoints));
                this.drawBezier(g2d, this.translatePath(rightPoints));
                if (!drawPoles) continue;
                Point2D.Double dot12 = this.transformLL2XY(north[ii][0] + 1.0E-5, 89.99999);
                Point2D.Double dot22 = this.transformLL2XY(north[ii][2] - 1.0E-5, 89.99999);
                polePath.moveTo((float)dot12.x, (float)dot12.y);
                polePath.lineTo((float)dot22.x, (float)dot22.y);
            }
            for (ii = 0; ii < south.length; ++ii) {
                leftPoints = new PointLL[jsteps + 1];
                rightPoints = new PointLL[jsteps + 1];
                for (int jj = 0; jj <= jsteps; ++jj) {
                    double lat = 0.0 - jstep * (double)jj;
                    if (jj == jsteps) {
                        lat = -89.99999;
                    }
                    leftPoints[jj] = new PointLL(south[ii][0] + 1.0E-5, lat);
                    rightPoints[jj] = new PointLL(south[ii][2] - 1.0E-5, lat);
                }
                this.drawBezier(g2d, this.translatePath(leftPoints));
                this.drawBezier(g2d, this.translatePath(rightPoints));
                if (!drawPoles) continue;
                Point2D.Double dot13 = this.transformLL2XY(south[ii][0] + 1.0E-5, -89.99999);
                Point2D.Double dot23 = this.transformLL2XY(south[ii][2] - 1.0E-5, -89.99999);
                polePath.moveTo((float)dot13.x, (float)dot13.y);
                polePath.lineTo((float)dot23.x, (float)dot23.y);
            }
            if (drawPoles) {
                g2d.draw(polePath);
            }
        }
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Path2D.Double path = new Path2D.Double();
        if (this.isRecenterableLon() || lat == 0.0) {
            double leftEdge = this.lambdaC_ - 180.0 + 1.0E-5;
            double rightEdge = this.lambdaC_ + 180.0 - 1.0E-5;
            Point2D.Double dot1 = this.transformLL2XY(leftEdge, lat);
            Point2D.Double dot2 = this.transformLL2XY(rightEdge, lat);
            if (dot1 != null && dot2 != null) {
                path.moveTo((float)dot1.x, (float)dot1.y);
                path.lineTo((float)dot2.x, (float)dot2.y);
            }
        } else if (lat > 0.0) {
            double[][] north = this.interruption_.getGores()[0];
            for (int ii = 0; ii < north.length; ++ii) {
                Point2D.Double dot1 = this.transformLL2XY(north[ii][0] + 1.0E-5, lat);
                Point2D.Double dot2 = this.transformLL2XY(north[ii][2] - 1.0E-5, lat);
                if (dot1 == null || dot2 == null) continue;
                path.moveTo((float)dot1.x, (float)dot1.y);
                path.lineTo((float)dot2.x, (float)dot2.y);
            }
        } else {
            double[][] south = this.interruption_.getGores()[1];
            for (int ii = 0; ii < south.length; ++ii) {
                Point2D.Double dot1 = this.transformLL2XY(south[ii][0] + 1.0E-5, lat);
                Point2D.Double dot2 = this.transformLL2XY(south[ii][2] - 1.0E-5, lat);
                if (dot1 == null || dot2 == null) continue;
                path.moveTo((float)dot1.x, (float)dot1.y);
                path.lineTo((float)dot2.x, (float)dot2.y);
            }
        }
        g2d.draw(path);
    }

    protected double getLongitudeForX(double x, double xFactor, double xFactor0, boolean north) {
        double clon;
        double cx;
        double dclon;
        if (this.isRecenterableLon()) {
            double lambdaRad = x * xFactor;
            if (Math.abs(lambdaRad) > Math.PI) {
                return Double.NaN;
            }
            return this.lambdaC_ + InterruptedPseudocylindric.toDegrees(lambdaRad);
        }
        double elon = InterruptedPseudocylindric.toDegrees(x * xFactor0);
        if (Math.abs(elon) > 180.0) {
            return Double.NaN;
        }
        double[] region = this.getRegion(elon += this.lambdaC_, north ? 1.0 : -1.0);
        double dlon1 = region[1] - region[0];
        double dlon2 = region[2] - region[1];
        if (dlon1 < 0.0) {
            dlon1 += 360.0;
        }
        if (dlon2 < 0.0) {
            dlon2 += 360.0;
        }
        if ((dclon = InterruptedPseudocylindric.toDegrees((x - (cx = this.lon2LambdaRad(clon = region[1]) / xFactor0)) * xFactor)) + dlon1 < 0.0) {
            return Double.NaN;
        }
        if (dclon - dlon2 > 0.0) {
            return Double.NaN;
        }
        return dclon + clon;
    }

    protected double[] getRegion(double lon, double lat) {
        double nlon = InterruptedPseudocylindric.normalizeLon180(lon);
        if (lat >= 0.0) {
            double[][] north = this.interruption_.getGores()[0];
            for (int i = 0; i < north.length; ++i) {
                if (!(nlon <= north[i][2])) continue;
                return north[i];
            }
            return north[0];
        }
        double[][] south = this.interruption_.getGores()[1];
        for (int i = 0; i < south.length; ++i) {
            if (!(nlon <= south[i][2])) continue;
            return south[i];
        }
        return south[0];
    }

    protected void setPoint(int ix, int iy, double lon, double phi) {
        int srcX;
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = InterruptedPseudocylindric.normalizeLon360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }
}

