/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ExtraParameter;

public class IntegerParameter
extends ExtraParameter {
    private int value_;
    private int defaultValue_;
    private int min_;
    private int max_;
    private boolean minAllowed_ = true;
    private boolean maxAllowed_ = true;

    public IntegerParameter(String name, String units, int value) {
        this(name, units, value, Integer.MIN_VALUE, Integer.MAX_VALUE, true, true);
    }

    public IntegerParameter(String name, String units, int value, int min, int max) {
        this(name, units, value, min, max, true, true);
    }

    public IntegerParameter(String name, String units, int value, int min, int max, boolean minAllowed, boolean maxAllowed) {
        super(name, units);
        this.min_ = min;
        this.max_ = max;
        this.minAllowed_ = minAllowed;
        this.maxAllowed_ = maxAllowed;
        this.defaultValue_ = value;
        this.reset();
    }

    public void reset() {
        this.setValue(this.defaultValue_);
    }

    public int getDefault() {
        return this.defaultValue_;
    }

    public int getValue() {
        return this.value_;
    }

    public void setValue(int value) throws IllegalArgumentException {
        if (value < this.min_) {
            throw new IllegalArgumentException("Value less than minimum: " + value + " < " + this.min_);
        }
        if (value <= this.min_ && !this.minAllowed_) {
            throw new IllegalArgumentException("Value must be greater than minimum: " + value + " <= " + this.min_);
        }
        if (value > this.max_) {
            throw new IllegalArgumentException("Value greater than maximum: " + value + " > " + this.max_);
        }
        if (value >= this.max_ && !this.maxAllowed_) {
            throw new IllegalArgumentException("Value must be less than maximum: " + value + " >= " + this.max_);
        }
        this.value_ = value;
        this.fireChange();
    }

    public Object getDefaultObject() {
        return this.defaultValue_;
    }

    public Object getValueObject() {
        return this.value_;
    }

    public void setValue(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        try {
            int i = Integer.parseInt(value);
            this.setValue(i);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not an integer: " + value);
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Value is not an Integer.");
        }
        this.setValue((Integer)value);
    }
}

