/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.EllipseProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Hammer
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Hammer";
    public static final int PROPERTIES = 16;
    private static final double WIDTH_FACTOR = 2.8284271247461903;
    private static final double HEIGHT_FACTOR = 1.4142135623730951;

    public Hammer(int width, int height) {
        this(width, height, 0, 0);
    }

    public Hammer(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Hammer(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, 2.8284271247461903, 1.4142135623730951);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double halfLambdaRad = 0.5 * this.lon2LambdaRad(lon);
        double phiRad = Hammer.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cos2Alpha = cosPhi * Math.cos(halfLambdaRad);
        double cosAlpha = Math.sqrt(0.5 * (1.0 + cos2Alpha));
        if (cosAlpha < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterY_);
        }
        double oneOverCosAlpha = 1.0 / cosAlpha;
        double x = 2.0 * cosPhi * Math.sin(halfLambdaRad) * oneOverCosAlpha;
        double y = sinPhi * oneOverCosAlpha;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double sinAlpha = 0.5 * this.oneOverRS_ * Math.hypot(0.5 * x, y);
        double alphaRad = Math.asin(sinAlpha);
        double cosAlpha = Math.cos(alphaRad);
        double cos2Alpha = Math.cos(2.0 * alphaRad);
        double phiRad = Math.asin(y * cosAlpha * this.oneOverRS_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosAlpha * 0.5 * this.oneOverRS_, cos2Alpha);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Hammer.toDegrees(phiRad);
        double lambda = Hammer.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double oneOverRS2 = this.oneOverRS_ * this.oneOverRS_;
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad;
                double x = (double)ix + 0.5;
                double sinAlpha = 0.5 * this.oneOverRS_ * Math.hypot(0.5 * x, y);
                double alphaRad = Math.asin(sinAlpha);
                double cosAlpha = Math.cos(alphaRad);
                double cos2Alpha = Math.cos(2.0 * alphaRad);
                double phiRad = Math.asin(y * cosAlpha * this.oneOverRS_);
                if (phiRad > 1.5707963267948966) continue block0;
                double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : 2.0 * Math.atan2(x * cosAlpha * 0.5 * this.oneOverRS_, cos2Alpha);
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, Hammer.toDegrees(lambdaRad), Hammer.toDegrees(phiRad));
            }
        }
    }
}

