/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AbstractProjection;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class GringortenCogley
extends AbstractProjection {
    public static final String PROJECTION_NAME = "(DEVO) Gringorten-Cogley";
    public static final int PROPERTIES = 0;
    private static final double TWO_PI = Math.PI * 2;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private static final double FOUR_OVER_PI = 1.2732395447351628;
    private static final double PI_OVER_6 = 0.5235987755982988;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 1.0;

    public GringortenCogley(int width, int height) {
        this(width, height, 0, 0);
    }

    public GringortenCogley(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GringortenCogley(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, 2.0, 1.0);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        BasicStroke bstroke;
        Stroke ostroke = g2d.getStroke();
        if (ostroke instanceof BasicStroke && ((bstroke = (BasicStroke)ostroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2d.setStroke(new BasicStroke(bstroke.getLineWidth(), 2, 0));
        }
        float top = (float)((double)this.outCenterY_ - this.rS_);
        float bottom = (float)((double)this.outCenterY_ + this.rS_);
        float left = (float)((double)this.outCenterX_ - 2.0 * this.rS_);
        float right = (float)((double)this.outCenterX_ + 2.0 * this.rS_);
        Path2D.Double path = new Path2D.Double();
        path.moveTo(left, top);
        path.lineTo(right, top);
        path.lineTo(right, bottom);
        path.lineTo(left, bottom);
        path.closePath();
        g2d.draw(path);
        g2d.setStroke(ostroke);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat == 0.0) {
            Path2D.Double path = new Path2D.Double();
            path.moveTo(this.outCenterX_, (float)((double)this.outCenterY_ - this.rS_));
            path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ + this.rS_));
            g2d.draw(path);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad;
        double lambdaRad;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        for (lambdaRad = this.lon2LambdaRad(lon + 90.0); lambdaRad < 0.0; lambdaRad += Math.PI * 2) {
        }
        int hexadecant = lat >= 0.0 ? (int)(lambdaRad / 0.7853981633974483) : (int)(lambdaRad / 0.7853981633974483) + 8;
        double qlambdaRad = lambdaRad % 1.5707963267948966;
        double hlambdaRad = hexadecant % 2 == 0 ? qlambdaRad : 1.5707963267948966 - qlambdaRad;
        double[] result = this.hexadecantTransformLL2XY(hlambdaRad, phiRad = GringortenCogley.toRadians(Math.abs(lat)));
        if (result == null) {
            return null;
        }
        double x = result[0];
        double y = result[1];
        switch (hexadecant) {
            case 0: {
                break;
            }
            case 1: {
                x = -x;
            }
            case 2: {
                double t = x;
                x = -y;
                y = t;
                break;
            }
            case 3: {
                y = -y;
                break;
            }
            case 4: {
                x = -x;
                y = -y;
                break;
            }
            case 5: {
                x = -x;
            }
            case 6: {
                double t = x;
                x = y;
                y = -t;
                break;
            }
            case 7: {
                x = -x;
                break;
            }
            case 8: {
                x = -x;
                break;
            }
            case 9: {
                double t = x;
                x = y;
                y = -t;
                break;
            }
            case 10: {
                double t = x = -x;
                x = y;
                y = -t;
                break;
            }
            case 11: {
                x = -x;
                y = -y;
                break;
            }
            case 12: {
                y = -y;
                break;
            }
            case 13: {
                double t = x;
                x = -y;
                y = t;
                break;
            }
            case 14: {
                double t = x = -x;
                x = -y;
                y = t;
                break;
            }
        }
        x = hexadecant < 8 ? (x -= 1.0) : (x += 1.0);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    private double[] hexadecantTransformLL2XY(double lambdaRad, double phiRad) {
        if (phiRad == 1.5707963267948966) {
            return new double[]{0.0, 0.0};
        }
        double sinPhi = Math.sin(phiRad);
        double r = sinPhi * sinPhi;
        double r2 = r * r;
        double onePlusR2 = 1.0 + r2;
        double onePlus3R2 = 1.0 + 3.0 * r2;
        double oneMinusR2 = 1.0 - r2;
        double sinZ = 1.0 / Math.sqrt(onePlusR2);
        double z = Math.asin(sinZ);
        double v = oneMinusR2 + r * onePlusR2 * z;
        double p2 = (1.0 - sinPhi) / v;
        double p = Math.sqrt(p2);
        double a2 = p2 * onePlusR2;
        double a = Math.sqrt(a2);
        double h = p * oneMinusR2;
        if (lambdaRad == 0.0) {
            return new double[]{0.0, -(h + r * a)};
        }
        double cosPhi = Math.cos(phiRad);
        double secPhi = 1.0 / cosPhi;
        double twoSinPhiCosPhi = 2.0 * sinPhi * cosPhi;
        double fourLambdaOverPi = 1.2732395447351628 * lambdaRad;
        if (lambdaRad > 0.6974335690969341 || phiRad < 0.7853981633974483 && lambdaRad > 0.5497787143782138) {
            double qa = 1.0 + r2;
            double qb = -2.0 * h;
            double qc = h * h - r2 * a2;
            double x45 = 0.5 * (-qb + Math.sqrt(qb * qb - 4.0 * qa * qc)) / qa;
            if (lambdaRad > 0.7853881633974483) {
                return new double[]{x45, x45};
            }
            double xBad = x45;
            double xGood = 0.5 * x45;
            double x = 0.5 * (xGood + xBad);
            for (int niter = 0; niter < 50; ++niter) {
                double drdphi = twoSinPhiCosPhi;
                double dvdphi = (-3.0 * r + z * onePlus3R2) * drdphi;
                double dp2dphi = (-v * cosPhi - (1.0 - sinPhi) * dvdphi) / (v * v);
                double dpdphi = 0.5 * dp2dphi / p;
                double dhdphi = oneMinusR2 * dpdphi - 2.0 * r * p * drdphi;
                double dra2dphi = r * onePlusR2 * dp2dphi + p2 * onePlus3R2 * drdphi;
                double zeta = -2.0 * secPhi * dhdphi;
                double mu = -secPhi * drdphi;
                double nu = -secPhi * dra2dphi;
                double g = Math.sqrt(a2 - x * x);
                double func = x * (zeta + mu * g) + nu * Math.asin(x / a) - fourLambdaOverPi;
                if (func == 0.0) {
                    return new double[]{x, -(h + r * g)};
                }
                if (func < 0.0) {
                    xGood = x;
                } else {
                    xBad = x;
                }
                x = 0.5 * (xGood + xBad);
                if (!(Math.abs(xBad - xGood) < 1.0E-5)) continue;
                return new double[]{x, -(h + r * g)};
            }
            return null;
        }
        double x = 1.0E-5;
        for (int iter = 0; iter < 25; ++iter) {
            double x2 = x * x;
            double drdphi = twoSinPhiCosPhi;
            double dvdphi = (-3.0 * r + z * onePlus3R2) * drdphi;
            double dp2dphi = (-v * cosPhi - (1.0 - sinPhi) * dvdphi) / (v * v);
            double dpdphi = 0.5 * dp2dphi / p;
            double dhdphi = oneMinusR2 * dpdphi - 2.0 * r * p * drdphi;
            double dra2dphi = r * onePlusR2 * dp2dphi + p2 * onePlus3R2 * drdphi;
            double zeta = -2.0 * secPhi * dhdphi;
            double mu = -secPhi * drdphi;
            double nu = -secPhi * dra2dphi;
            double g = Math.sqrt(a2 - x2);
            double dgdx = -x / g;
            double zetaPlusMuG = zeta + mu * g;
            double func = x * zetaPlusMuG + nu * Math.asin(x / a) - fourLambdaOverPi;
            double dfunc = zetaPlusMuG + mu * x * dgdx + nu / a / Math.sqrt(1.0 - x2 / a2);
            double dx = -func / dfunc;
            x += dx;
            if (Math.abs(dx) < 1.0E-5) break;
        }
        double g = Math.sqrt(a2 - x * x);
        double y = -(h + r * g);
        return new double[]{x, y};
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 0.0;
        double lambdaRad = 0.0;
        double phi = GringortenCogley.toDegrees(0.0);
        double lambda = GringortenCogley.toDegrees(0.0);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = -((double)iy + 0.5) * this.oneOverRS_;
            for (int ix = 0; ix <= iy; ++ix) {
                double yphprg;
                int niter;
                double x = ((double)ix + 0.5) * this.oneOverRS_;
                double rGood = 0.0;
                double rBad = 1.0;
                double r = 0.5;
                for (niter = 0; niter < 50 && (yphprg = this.yPlusHPlusRG(x, y, r)) != 0.0; ++niter) {
                    if (yphprg > 0.0) {
                        rGood = r;
                    } else {
                        rBad = r;
                    }
                    r = 0.5 * (rGood + rBad);
                    if (Math.abs(rBad - rGood) < 1.0E-5) break;
                }
                if (niter > 45) continue;
                double sinPhi = Math.sqrt(r);
                double phiRad = Math.asin(sinPhi);
                if (ix == iy) {
                    this.setRasterPoints(ix, iy, 45.0, GringortenCogley.toDegrees(phiRad));
                    continue block0;
                }
                double r2 = r * r;
                double onePlusR2 = 1.0 + r2;
                double oneMinusR2 = 1.0 - r2;
                double sinZ = 1.0 / Math.sqrt(onePlusR2);
                double z = Math.asin(sinZ);
                double v = oneMinusR2 + r * onePlusR2 * z;
                double p2 = (1.0 - Math.sqrt(r)) / v;
                double p = Math.sqrt(p2);
                double a2 = p2 * onePlusR2;
                double a = Math.sqrt(a2);
                double h = p * oneMinusR2;
                double g2 = a2 - x * x;
                double g = Math.sqrt(g2);
                double cosPhi = Math.cos(phiRad);
                double secPhi = 1.0 / cosPhi;
                double twoSinPhiCosPhi = 2.0 * sinPhi * cosPhi;
                double onePlus3R2 = 1.0 + 3.0 * r2;
                double drdphi = twoSinPhiCosPhi;
                double dvdphi = (-3.0 * r + z * onePlus3R2) * drdphi;
                double dp2dphi = (-v * cosPhi - (1.0 - sinPhi) * dvdphi) / (v * v);
                double dpdphi = 0.5 * dp2dphi / p;
                double dhdphi = oneMinusR2 * dpdphi - 2.0 * r * p * drdphi;
                double dra2dphi = r * onePlusR2 * dp2dphi + p2 * onePlus3R2 * drdphi;
                double zeta = -2.0 * secPhi * dhdphi;
                double mu = -secPhi * drdphi;
                double nu = -secPhi * dra2dphi;
                double zetaPlusMuG = zeta + mu * g;
                double lambdaRad = 0.7853981633974483 * (x * zetaPlusMuG + nu * Math.asin(x / a));
                this.setRasterPoints(ix, iy, GringortenCogley.toDegrees(lambdaRad), GringortenCogley.toDegrees(phiRad));
            }
        }
    }

    private double yPlusHPlusRG(double x, double y, double r) {
        double r2 = r * r;
        double onePlusR2 = 1.0 + r2;
        double oneMinusR2 = 1.0 - r2;
        double sinZ = 1.0 / Math.sqrt(onePlusR2);
        double z = Math.asin(sinZ);
        double v = oneMinusR2 + r * onePlusR2 * z;
        double p2 = (1.0 - Math.sqrt(r)) / v;
        double p = Math.sqrt(p2);
        double a2 = p2 * onePlusR2;
        double h = p * oneMinusR2;
        double g2 = a2 - x * x;
        double g = Math.sqrt(g2);
        return y + h + r * g;
    }

    protected void setRasterPoints(int ix, int iy, double dlambda, double phi) {
        int srcY = this.getSrcPixelY(phi);
        if (srcY <= -1) {
            return;
        }
        int[] col = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] row = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        col[0] = this.outCenterX_ + ix;
        col[1] = this.outCenterX_ + iy;
        col[2] = col[1];
        col[3] = col[0];
        col[4] = this.outCenterX_ - ix - 1;
        col[5] = this.outCenterX_ - iy - 1;
        col[6] = col[5];
        col[7] = col[4];
        row[0] = this.outCenterY_ + iy;
        row[1] = this.outCenterY_ + ix;
        row[2] = this.outCenterY_ - ix - 1;
        row[3] = this.outCenterY_ - iy - 1;
        row[4] = row[3];
        row[5] = row[2];
        row[6] = row[1];
        row[7] = row[0];
        for (int i = 0; i < 8; ++i) {
            if (row[i] < 0 || row[i] >= this.outHeight_ || col[i] < 0 || col[i] >= this.outWidth_) continue;
            double lambda = i % 2 == 0 ? this.lambdaC_ + (double)(i * 45) + dlambda : this.lambdaC_ + (double)i * 45.0 + 45.0 - dlambda;
            int offset = row[i] * this.outWidth_ + col[i];
            this.invArrayLon_[offset] = GringortenCogley.normalizeLon360(lambda);
            this.invArrayLat_[offset] = phi;
            int srcX = this.getSrcPixelX(lambda);
            if (srcX <= -1) continue;
            this.invArray_[offset] = srcY * this.srcWidth_ + srcX;
        }
    }
}

