/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class GottMugnoloAzimuthal
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Gott-Mugnolo Azimuthal";
    public static final int PROPERTIES = 131104;
    private static final double CONST_A = 0.446;
    private static final double ONE_OVER_A = 2.242152466367713;
    private static final double SIN_A_PI = Math.sin(1.4011503235010478);
    private static final double DEFAULT_RADIUS = 90.0;
    private double radiusDeg_ = 90.0;
    private boolean fillCorners_;

    public GottMugnoloAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public GottMugnoloAzimuthal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GottMugnoloAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131104, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new DoubleParameter("Radius", "\u00b0", 90.0, 1.0E-4, 180.0, true, true));
        this.addParameter(new BooleanParameter("Fill corners", false));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            this.setRadius(((DoubleParameter)this.getParameter(0)).getValue());
            this.setFillCorners(((BooleanParameter)this.getParameter(1)).isSelected());
        } else if (p == this.getParameter(0)) {
            this.setRadius(((DoubleParameter)p).getValue());
        } else if (p == this.getParameter(1)) {
            this.setFillCorners(((BooleanParameter)p).isSelected());
        } else {
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    public void setRadius(double r) {
        this.radiusDeg_ = r;
        this.autoscale();
    }

    public void setFillCorners(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    protected void prepareScaling() {
        double rhoMaxOverR = SIN_A_PI * Math.sin(0.446 * Math.toRadians(this.radiusDeg_));
        this.setSizeFactors(rhoMaxOverR, rhoMaxOverR);
    }

    protected void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = SIN_A_PI * SIN_A_PI;
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double rho2;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = GottMugnoloAzimuthal.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        double z = Math.acos(cosZ);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(z) > 1.0E-5) {
            double k = Math.sin(0.446 * z) / Math.sin(z);
            x = k * cosPhi * Math.sin(lambdaRad);
            y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        }
        if ((rho2 = x * x + y * y) * this.rS_ * this.rS_ > this.rhoBorder2_) {
            return null;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = 2.242152466367713 * Math.asin(rho * this.oneOverRS_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phi = GottMugnoloAzimuthal.toDegrees(phiRad);
        double lambda = GottMugnoloAzimuthal.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > this.rhoBorder2_) continue;
                double rho = Math.sqrt(rho2);
                double z = 2.242152466367713 * Math.asin(rho * this.oneOverRS_);
                double sinZ = Math.sin(z);
                double cosZ = Math.cos(z);
                double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
                double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
                this.setBiSymmetricPoints(ix, iy, GottMugnoloAzimuthal.toDegrees(lambdaRad), GottMugnoloAzimuthal.toDegrees(phiRad));
            }
        }
    }
}

