/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.EllipseProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class GottEqualArea
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Gott Equal-Area Elliptical";
    public static final int PROPERTIES = 16;
    private static final double WIDTH_FACTOR = 1.4142135623730951;
    private static final double HEIGHT_FACTOR = 0.8723580249548598;
    private static final double ONE_OVER_SQRT2 = 0.7071067811865475;
    private static final double ONE_OVER_PI = 0.3183098861837907;
    private static final double AXES_RATIO = 0.6168502750680848;

    public GottEqualArea(int width, int height) {
        this(width, height, 0, 0);
    }

    public GottEqualArea(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GottEqualArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, 1.4142135623730951, 0.8723580249548598);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double halfLambdaRad = 0.5 * this.lon2LambdaRad(lon);
        double phiRad = GottEqualArea.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double sinPhiP = cosPhi * Math.sin(halfLambdaRad);
        double phiPRad = Math.asin(sinPhiP);
        double sin2LambdaP = sinPhi / Math.cos(phiPRad);
        double lambdaPRad = 0.5 * Math.asin(sin2LambdaP);
        double piSinPhiP = Math.PI * sinPhiP;
        double thetaRad = phiPRad * 1.5707963267948966 * 0.5;
        for (int iter = 0; iter < 25; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhiP;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = 1.4142135623730951 * Math.sin(thetaRad);
        double y = 1.1107207345395915 * lambdaPRad * Math.cos(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double sinTheta = x * this.oneOverRS_ * 0.7071067811865475;
        double thetaRad = Math.asin(sinTheta);
        double lambdaPRad = y * this.oneOverRS_ * 2.0 * 1.4142135623730951 * 0.3183098861837907 / Math.cos(thetaRad);
        double sinPhiP = (2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907;
        double phiPRad = Math.asin(sinPhiP);
        double phiRad = Math.asin(Math.sin(2.0 * lambdaPRad) * Math.cos(phiPRad));
        double lambdaRad = 2.0 * Math.asin(sinPhiP / Math.cos(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = GottEqualArea.toDegrees(phiRad);
        double lambda = GottEqualArea.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double rho2 = this.yMax_ * this.yMax_;
        block0: for (int ix = 0; ix < this.xMax_; ++ix) {
            double y;
            double x = (double)ix + 0.5;
            double sinTheta = x * this.oneOverRS_ * 0.7071067811865475;
            double thetaRad = Math.asin(sinTheta);
            double twoThetaRad = 2.0 * thetaRad;
            double yFactor = this.oneOverRS_ * 1.4142135623730951 * 2.0 * 0.3183098861837907 / Math.cos(thetaRad);
            double x2ratio2 = x * x * 0.6168502750680848 * 0.6168502750680848;
            for (int iy = 0; iy < this.yMax_ && !(x2ratio2 + (y = (double)iy + 0.5) * y > rho2); ++iy) {
                double lambdaRad;
                double lambdaPRad = y * yFactor;
                double sinPhiP = (twoThetaRad + Math.sin(twoThetaRad)) * 0.3183098861837907;
                double phiPRad = Math.asin(sinPhiP);
                double phiRad = Math.asin(Math.sin(2.0 * lambdaPRad) * Math.cos(phiPRad));
                if (Math.abs(phiRad) > 1.5707963267948966 || Math.abs(lambdaRad = 2.0 * Math.asin(sinPhiP / Math.cos(phiRad))) > Math.PI) continue block0;
                double phi = GottEqualArea.toDegrees(phiRad);
                double lambda = GottEqualArea.toDegrees(lambdaRad);
                this.setQSymmetricPoints(ix, iy, GottEqualArea.toDegrees(lambdaRad), GottEqualArea.toDegrees(phiRad));
            }
        }
    }
}

