/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class GoodeHomolosine
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Goode Homolosine";
    public static final int PROPERTIES = 786436;
    private static final double JOIN_LAT = 40.7333333333;
    private static final double YSHIFT = 0.0528;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.3614135623730952;
    private static final double ONE_OVER_SQRT2 = 0.7071067811865475;
    private static final double ONE_OVER_PI = 0.3183098861837907;
    private double joinY_;

    public GoodeHomolosine(int width, int height) {
        this(width, height, 0, 0);
    }

    public GoodeHomolosine(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GoodeHomolosine(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 786436, width, height, xmargin, ymargin, Math.PI, 1.3614135623730952);
        this.autoscale();
    }

    protected void finishScaling() {
        this.joinY_ = this.rS_ * GoodeHomolosine.toRadians(40.7333333333);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.3614135623730952 * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.3614135623730952 * this.rS_);
        }
        double phiRad = GoodeHomolosine.toRadians(lat);
        double thetaRad = 0.0;
        if (Math.abs(lat) > 40.7333333333) {
            double piSinPhi = Math.PI * Math.sin(phiRad);
            thetaRad = phiRad;
            for (int iter = 0; iter < 25; ++iter) {
                double twoThetaRad = 2.0 * thetaRad;
                double dthetaRad = 0.5 * (piSinPhi - twoThetaRad - Math.sin(twoThetaRad)) / (1.0 + Math.cos(twoThetaRad));
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = 1.4142135623730951 * Math.sin(thetaRad);
            y = lat > 0.0 ? (y -= 0.0528) : (y += 0.0528);
        } else {
            y = phiRad;
        }
        if (!this.isShowingInterrupted()) {
            x = this.lon2LambdaRad(lon);
            x = Math.abs(lat) > 40.7333333333 ? (x *= 1.4142135623730951 * Math.cos(thetaRad) / 1.5707963267948966) : (x *= Math.cos(phiRad));
        } else {
            double[] region = this.getRegion(lon, lat);
            double clon = region[1];
            double dlon = GoodeHomolosine.normalizeLon180(lon) - clon;
            if (GoodeHomolosine.normalizeLon180(lon) > region[2]) {
                dlon -= 360.0;
            }
            double cx = this.lon2LambdaRad(clon);
            x = Math.abs(lat) > 40.7333333333 ? 1.4142135623730951 * Math.cos(thetaRad) / 1.5707963267948966 : Math.cos(phiRad);
            x = cx + GoodeHomolosine.toRadians(dlon) * x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinY_) {
            double yOverRS = Math.abs(y) * this.oneOverRS_ + 0.0528;
            double thetaRad = Math.asin(yOverRS * 0.7071067811865475);
            phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = 1.5707963267948966 * this.oneOverRS_ * 0.7071067811865475 / Math.cos(thetaRad);
        } else {
            phiRad = y * this.oneOverRS_;
            xFactor = this.oneOverRS_ / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = GoodeHomolosine.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double xFactor;
            double phiRad;
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            if (Math.abs(y) > this.joinY_) {
                yOverRS = y > 0.0 ? (yOverRS += 0.0528) : (yOverRS -= 0.0528);
                double thetaRad = Math.asin(yOverRS * 0.7071067811865475);
                phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) * 0.3183098861837907);
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                xFactor = 1.5707963267948966 * this.oneOverRS_ * 0.7071067811865475 / Math.cos(thetaRad);
            } else {
                phiRad = y * this.oneOverRS_;
                xFactor = this.oneOverRS_ / Math.cos(phiRad);
            }
            double phi = GoodeHomolosine.toDegrees(phiRad);
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lon = this.getLongitudeForX(x, xFactor, this.oneOverRS_, phi > 0.0);
                if (Double.isNaN(lon)) continue;
                this.setPoint(ix, iy, lon, phi);
            }
        }
    }
}

