/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class GnomonicCubedSphere
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Gnomonic Cubed Sphere";
    public static final int PROPERTIES = 0;
    private static final double WIDTH_FACTOR = 4.0;
    private static final double HEIGHT_FACTOR = 3.0;
    private static final int FACE1 = 0;
    private static final int FACE2 = 1;
    private static final int FACE3 = 2;
    private static final int FACE4 = 3;
    private static final int TOP = 4;
    private static final int BOTTOM = 5;
    private int npFace_;
    private int spFace_;
    private double twoRS_;
    private double threeRS_;
    private double fourRS_;

    public GnomonicCubedSphere(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GnomonicCubedSphere(int width, int height) {
        this(width, height, 0, 0);
    }

    public GnomonicCubedSphere(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0, width, height, xmargin, ymargin, 4.0, 3.0);
        this.addParameter(new ListParameter("NP Above Face", new Integer[]{1, 2, 3, 4}, 1));
        this.addParameter(new ListParameter("SP Below Face", new Integer[]{1, 2, 3, 4}, 1));
        this.parameterChanged(null);
    }

    public void parameterChanged(ProjParameterEvent e) {
        this.npFace_ = ((ListParameter)this.getParameter(0)).getSelectedIndex();
        this.spFace_ = ((ListParameter)this.getParameter(1)).getSelectedIndex();
        this.autoscale();
    }

    protected void finishScaling() {
        this.twoRS_ = 2.0 * this.rS_;
        this.threeRS_ = 3.0 * this.rS_;
        this.fourRS_ = 4.0 * this.rS_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (lat < -90.0 || lat > 90.0) {
            return null;
        }
        double lonb = lon + 45.0;
        double lambdaRad = this.lon2LambdaRad(lonb);
        double phiRad = GnomonicCubedSphere.toRadians(lat);
        double cosPhiRad = Math.cos(phiRad);
        double xx = Math.cos(lambdaRad) * cosPhiRad;
        double yy = Math.sin(lambdaRad) * cosPhiRad;
        double zz = Math.sin(phiRad);
        double absXX = Math.abs(xx);
        double absYY = Math.abs(yy);
        double absZZ = Math.abs(zz);
        double ratio = 0.0;
        int face = 0;
        if (absXX >= absYY && absXX >= absZZ) {
            ratio = 1.0 / absXX;
            face = xx > 0.0 ? 1 : 3;
        } else if (absYY >= absXX && absYY >= absZZ) {
            ratio = 1.0 / absYY;
            face = yy > 0.0 ? 2 : 0;
        } else {
            ratio = 1.0 / absZZ;
            face = zz > 0.0 ? 4 : 5;
        }
        xx *= ratio;
        yy *= ratio;
        zz *= ratio;
        switch (face) {
            case 0: {
                yy = -2.0 + xx;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                yy = 2.0 - xx;
                break;
            }
            case 3: {
                yy = 4.0 - yy;
                break;
            }
            case 4: {
                switch (this.npFace_) {
                    case 0: {
                        double tt = xx;
                        xx = -yy;
                        yy = tt - 2.0;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        double tt = xx;
                        xx = yy;
                        yy = -tt + 2.0;
                        break;
                    }
                    case 3: {
                        xx = -xx;
                        yy = -yy + 4.0;
                    }
                }
                zz = 2.0 - xx;
                break;
            }
            case 5: {
                switch (this.spFace_) {
                    case 0: {
                        double tt = xx;
                        xx = -yy;
                        yy = tt - 2.0;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        double tt = xx;
                        xx = yy;
                        yy = -tt + 2.0;
                        break;
                    }
                    case 3: {
                        xx = -xx;
                        yy = -yy + 4.0;
                    }
                }
                zz = -2.0 + xx;
            }
        }
        double x = (double)this.outCenterX_ + (yy -= 1.0) * this.rS_;
        double y = (double)this.outCenterY_ - zz * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xxx, double yyy) {
        double x = xxx + this.rS_ - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yyy;
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        if (Math.abs(yOverRS) <= 1.0) {
            if (xOverRS < -3.0 || xOverRS > 5.0) {
                return null;
            }
            int face = 1;
            double yy = xOverRS;
            double zz = yOverRS;
            if (xOverRS < -1.0) {
                face = 0;
                yy += 2.0;
            } else if (xOverRS > 3.0) {
                face = 3;
                yy -= 4.0;
            } else if (xOverRS > 1.0) {
                face = 2;
                yy -= 2.0;
            } else {
                face = 1;
            }
            double rhoQ = Math.sqrt(yy * yy + zz * zz + 1.0);
            double xx = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (zz /= rhoQ) * zz);
            double dlambdaRad = Math.atan2(yy, xx);
            double dlambda = GnomonicCubedSphere.toDegrees(dlambdaRad);
            double phiRad = Math.asin(zz);
            double phi = GnomonicCubedSphere.toDegrees(phiRad);
            if (face == 2) {
                dlambda += 90.0;
            } else if (face == 3) {
                dlambda += 180.0;
            } else if (face == 0) {
                dlambda -= 90.0;
            }
            return new PointLL(this.lambdaC_ + dlambda - 45.0, phi);
        }
        if (Math.abs(yOverRS) <= 3.0) {
            double yy = xOverRS;
            double xx = 2.0 - Math.abs(yOverRS);
            int switchface = yOverRS > 0.0 ? this.npFace_ : this.spFace_;
            switch (switchface) {
                case 0: {
                    if (xOverRS < -3.0 || xOverRS > -1.0) {
                        return null;
                    }
                    yy = xOverRS + 2.0;
                    break;
                }
                case 1: {
                    if (xOverRS < -1.0 || xOverRS > 1.0) {
                        return null;
                    }
                    yy = xOverRS;
                    break;
                }
                case 2: {
                    if (xOverRS < 1.0 || xOverRS > 3.0) {
                        return null;
                    }
                    yy = xOverRS - 2.0;
                    break;
                }
                case 3: {
                    if (xOverRS < 3.0 || xOverRS > 5.0) {
                        return null;
                    }
                    yy = xOverRS - 4.0;
                }
            }
            double rhoQ = Math.sqrt(yy * yy + xx * xx + 1.0);
            double zz = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (xx /= rhoQ) * xx);
            double dlambdaRad = Math.atan2(yy, xx);
            double dlambda = GnomonicCubedSphere.toDegrees(dlambdaRad);
            double phiRad = Math.asin(zz);
            double phi = GnomonicCubedSphere.toDegrees(phiRad);
            switch (switchface) {
                case 0: {
                    dlambda -= 90.0;
                    break;
                }
                case 2: {
                    dlambda += 90.0;
                    break;
                }
                case 3: {
                    dlambda += 180.0;
                }
            }
            if (yOverRS < 0.0) {
                phi *= -1.0;
            }
            return new PointLL(this.lambdaC_ + dlambda - 45.0, phi);
        }
        return null;
    }

    protected synchronized void calculateInverseArray() {
        int iy = 0;
        while ((double)iy < this.threeRS_) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            int ix = 0;
            while ((double)ix < this.rS_) {
                double phi;
                double phiRad;
                double dlambda;
                double dlambdaRad;
                double xx;
                double rhoQ;
                double zz;
                double yy;
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                if (yOverRS <= 1.0) {
                    yy = xOverRS;
                    zz = yOverRS;
                    rhoQ = Math.sqrt(yy * yy + zz * zz + 1.0);
                    xx = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (zz /= rhoQ) * zz);
                    dlambdaRad = Math.atan2(yy, xx);
                    dlambda = GnomonicCubedSphere.toDegrees(dlambdaRad);
                    phiRad = Math.asin(zz);
                    phi = GnomonicCubedSphere.toDegrees(phiRad);
                    this.setFacePoint(ix, iy, dlambda, phi);
                } else {
                    yy = xOverRS;
                    xx = 2.0 - yOverRS;
                    rhoQ = Math.sqrt(yy * yy + xx * xx + 1.0);
                    zz = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (xx /= rhoQ) * xx);
                    dlambdaRad = Math.atan2(yy, xx);
                    dlambda = GnomonicCubedSphere.toDegrees(dlambdaRad);
                    phiRad = Math.asin(zz);
                    phi = GnomonicCubedSphere.toDegrees(phiRad);
                    this.setPolePoint(ix, iy, dlambda, phi);
                }
                ++ix;
            }
            ++iy;
        }
    }

    private void setFacePoint(int ix, int iy, double dlambda, double phi) {
        int ixM = -ix - 1;
        int iyM = -iy - 1;
        this.setPoint((int)((double)ix - this.threeRS_), iy, dlambda - 90.0, phi);
        this.setPoint((int)((double)ixM - this.threeRS_), iy, -dlambda - 90.0, phi);
        this.setPoint((int)((double)ix - this.threeRS_), iyM, dlambda - 90.0, -phi);
        this.setPoint((int)((double)ixM - this.threeRS_), iyM, -dlambda - 90.0, -phi);
        this.setPoint((int)((double)ix - this.rS_), iy, dlambda, phi);
        this.setPoint((int)((double)ixM - this.rS_), iy, -dlambda, phi);
        this.setPoint((int)((double)ix - this.rS_), iyM, dlambda, -phi);
        this.setPoint((int)((double)ixM - this.rS_), iyM, -dlambda, -phi);
        this.setPoint((int)((double)ix + this.rS_), iy, dlambda + 90.0, phi);
        this.setPoint((int)((double)ixM + this.rS_), iy, -dlambda + 90.0, phi);
        this.setPoint((int)((double)ix + this.rS_), iyM, dlambda + 90.0, -phi);
        this.setPoint((int)((double)ixM + this.rS_), iyM, -dlambda + 90.0, -phi);
        this.setPoint((int)((double)ix + this.threeRS_), iy, dlambda + 180.0, phi);
        this.setPoint((int)((double)ixM + this.threeRS_), iy, -dlambda + 180.0, phi);
        this.setPoint((int)((double)ix + this.threeRS_), iyM, dlambda + 180.0, -phi);
        this.setPoint((int)((double)ixM + this.threeRS_), iyM, -dlambda + 180.0, -phi);
    }

    private void setPolePoint(int ix, int iy, double dlambda, double phi) {
        int ixM = -ix - 1;
        int iyM = -iy - 1;
        switch (this.npFace_) {
            case 0: {
                this.setPoint((int)((double)ix - this.threeRS_), iy, dlambda - 90.0, phi);
                this.setPoint((int)((double)ixM - this.threeRS_), iy, -dlambda - 90.0, phi);
                break;
            }
            case 1: {
                this.setPoint((int)((double)ix - this.rS_), iy, dlambda, phi);
                this.setPoint((int)((double)ixM - this.rS_), iy, -dlambda, phi);
                break;
            }
            case 2: {
                this.setPoint((int)((double)ix + this.rS_), iy, dlambda + 90.0, phi);
                this.setPoint((int)((double)ixM + this.rS_), iy, -dlambda + 90.0, phi);
                break;
            }
            case 3: {
                this.setPoint((int)((double)ix + this.threeRS_), iy, dlambda + 180.0, phi);
                this.setPoint((int)((double)ixM + this.threeRS_), iy, -dlambda + 180.0, phi);
            }
        }
        switch (this.spFace_) {
            case 0: {
                this.setPoint((int)((double)ix - this.threeRS_), iyM, dlambda - 90.0, -phi);
                this.setPoint((int)((double)ixM - this.threeRS_), iyM, -dlambda - 90.0, -phi);
                break;
            }
            case 1: {
                this.setPoint((int)((double)ix - this.rS_), iyM, dlambda, -phi);
                this.setPoint((int)((double)ixM - this.rS_), iyM, -dlambda, -phi);
                break;
            }
            case 2: {
                this.setPoint((int)((double)ix + this.rS_), iyM, dlambda + 90.0, -phi);
                this.setPoint((int)((double)ixM + this.rS_), iyM, -dlambda + 90.0, -phi);
                break;
            }
            case 3: {
                this.setPoint((int)((double)ix + this.threeRS_), iyM, dlambda + 180.0, -phi);
                this.setPoint((int)((double)ixM + this.threeRS_), iyM, -dlambda + 180.0, -phi);
            }
        }
    }

    private void setPoint(int ix, int iy, double dlambda, double phi) {
        int srcX;
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        double lon = this.lambdaC_ + dlambda - 45.0;
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = GnomonicCubedSphere.normalizeLon360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }

    protected void drawBorderLines(Graphics2D g2d) {
        BasicStroke bstroke;
        Stroke ostroke = g2d.getStroke();
        if (ostroke instanceof BasicStroke && ((bstroke = (BasicStroke)ostroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2d.setStroke(new BasicStroke(bstroke.getLineWidth(), 2, 0));
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo((float)((double)this.outCenterX_ - this.fourRS_), (float)((double)this.outCenterY_ - this.rS_));
        switch (this.npFace_) {
            case 0: {
                path.lineTo((float)((double)this.outCenterX_ - this.fourRS_), (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ - this.rS_));
                break;
            }
            case 1: {
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ - this.rS_));
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ - this.rS_));
                break;
            }
            case 2: {
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ - this.rS_));
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ - this.rS_));
                break;
            }
            case 3: {
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ - this.rS_));
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ - this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ + this.fourRS_), (float)((double)this.outCenterY_ - this.threeRS_));
            }
        }
        path.lineTo((float)((double)this.outCenterX_ + this.fourRS_), (float)((double)this.outCenterY_ - this.rS_));
        path.lineTo((float)((double)this.outCenterX_ + this.fourRS_), (float)((double)this.outCenterY_ + this.rS_));
        switch (this.spFace_) {
            case 0: {
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ + this.rS_));
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ - this.fourRS_), (float)((double)this.outCenterY_ + this.threeRS_));
                break;
            }
            case 1: {
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ + this.rS_));
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ - this.twoRS_), (float)((double)this.outCenterY_ + this.rS_));
                break;
            }
            case 2: {
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ + this.rS_));
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo(this.outCenterX_, (float)((double)this.outCenterY_ + this.rS_));
                break;
            }
            case 3: {
                path.lineTo((float)((double)this.outCenterX_ + this.fourRS_), (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ + this.threeRS_));
                path.lineTo((float)((double)this.outCenterX_ + this.twoRS_), (float)((double)this.outCenterY_ + this.rS_));
            }
        }
        path.lineTo((float)((double)this.outCenterX_ - this.fourRS_), (float)((double)this.outCenterY_ + this.rS_));
        path.closePath();
        g2d.draw(path);
        g2d.setStroke(ostroke);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotNP = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotP45 = this.transformLL2XY(lon, 45.01);
        double dx = dotP45.x - dotNP.x;
        double dy = dotP45.y - dotNP.y;
        double r = Math.hypot(dx, dy);
        double ratio = Math.abs(dx) > Math.abs(dy) ? this.rS_ / Math.abs(dx) : this.rS_ / Math.abs(dy);
        GraphicUtilities.drawLine(g2d, (float)dotNP.x, (float)dotNP.y, (float)(dotNP.x + (dx *= ratio)), (float)(dotNP.y + (dy *= ratio)));
        GraphicUtilities.drawLine(g2d, (float)dot0.x, (float)(dot0.y - this.rS_), (float)dot0.x, (float)(dot0.y + this.rS_));
        Point2D.Double dotSP = this.transformLL2XY(lon, -90.0);
        Point2D.Double dotM45 = this.transformLL2XY(lon, -45.01);
        dx = dotM45.x - dotSP.x;
        dy = dotM45.y - dotSP.y;
        r = Math.hypot(dx, dy);
        ratio = Math.abs(dx) > Math.abs(dy) ? this.rS_ / Math.abs(dx) : this.rS_ / Math.abs(dy);
        GraphicUtilities.drawLine(g2d, (float)(dotSP.x + (dx *= ratio)), (float)(dotSP.y + (dy *= ratio)), (float)dotSP.x, (float)dotSP.y);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat == 0.0) {
            Point2D.Double dotw = this.transformLL2XY(this.lambdaC_ - 179.99, 0.0);
            Point2D.Double dote = this.transformLL2XY(this.lambdaC_ + 179.99, 0.0);
            GraphicUtilities.drawLine(g2d, (float)dotw.x, (float)dotw.y, (float)dote.x, (float)dotw.y);
        } else if (Math.abs(lat) >= 45.0) {
            Point2D.Double dotP = lat > 0.0 ? this.transformLL2XY(this.lambdaC_, 90.0) : this.transformLL2XY(this.lambdaC_, -90.0);
            double radius = this.rS_;
            if (Math.abs(lat) > 45.0) {
                Point2D.Double dotL = this.transformLL2XY(this.lambdaC_, lat);
                radius = 1.4142135623730951 * Math.abs(dotP.y - dotL.y);
            }
            Ellipse2D.Double ellipse = new Ellipse2D.Double(dotP.x - radius, dotP.y - radius, radius * 2.0, radius * 2.0);
            g2d.draw(ellipse);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }
}

