/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Ginzburg8
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Ginzburg VIII";
    private static final double TERMA = 0.08333333333333333;
    private static final double TERMB = 0.162388;
    private static final double TERMC = 0.87;
    private static final double TERMD = 9.52426E-4;
    private static final double WIDTH_FACTOR = 2.4417245043218134;
    private static final double HEIGHT_FACTOR = 1.8937783755480195;

    public Ginzburg8(int width, int height) {
        this(width, height, 0, 0);
    }

    public Ginzburg8(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Ginzburg8(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.4417245043218134, 1.8937783755480195);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Ginzburg8.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double lambdaRad = this.lon2LambdaRad(lon);
        double lambdaRad2 = lambdaRad * lambdaRad;
        double x = (1.0 - 0.162388 * phiRad2) * (0.87 - 9.52426E-4 * lambdaRad2 * lambdaRad2) * lambdaRad;
        double y = phiRad * (1.0 + 0.08333333333333333 * phiRad2);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad2;
        double dlambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double dphiRad = -(phiRad * (1.0 + 0.08333333333333333 * phiRad2) - yOverRS) / (1.0 + 0.16666666666666666 * phiRad2);
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xTerm = x * this.oneOverRS_ / (1.0 - 0.162388 * phiRad * phiRad);
        double lambdaRad = 1.5707963267948966;
        for (int iter = 0; iter < 25 && !(Math.abs(lambdaRad += (dlambdaRad = -(lambdaRad * (0.87 - 9.52426E-4 * (lambdaRad2 = lambdaRad * lambdaRad) * lambdaRad2) - xTerm) / (0.87 - 0.00476213 * lambdaRad2 * lambdaRad2))) < 1.0E-5); ++iter) {
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Ginzburg8.toDegrees(phiRad);
        double lambda = Ginzburg8.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double twoOverRS = 2.0 * this.oneOverRS_;
        double phiRad = 0.0;
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            for (int iter = 0; iter < 25; ++iter) {
                double phiRad2 = phiRad * phiRad;
                double dphiRad = -(phiRad * (1.0 + 0.08333333333333333 * phiRad2) - yOverRS) / (1.0 + 0.16666666666666666 * phiRad2);
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (Math.abs(phiRad) > 1.5707963267948966) break;
            double phi = Ginzburg8.toDegrees(phiRad);
            double xTerm = this.oneOverRS_ / (1.0 - 0.162388 * phiRad * phiRad);
            double lambdaRad = 0.0;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad2;
                double dlambdaRad;
                double x = (double)ix + 0.5;
                for (int iter = 0; iter < 25 && !(Math.abs(lambdaRad += (dlambdaRad = -(lambdaRad * (0.87 - 9.52426E-4 * (lambdaRad2 = lambdaRad * lambdaRad) * lambdaRad2) - x * xTerm) / (0.87 - 0.00476213 * lambdaRad2 * lambdaRad2))) < 1.0E-5); ++iter) {
                }
                if (Math.abs(lambdaRad) > Math.PI || lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, Ginzburg8.toDegrees(lambdaRad), phi);
            }
        }
    }
}

