/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.ConcavePoleProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Ginzburg4
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Ginzburg IV";
    public static final int PROPERTIES = 16;
    private static final double B1 = 2.8283;
    private static final double B2 = -1.69845;
    private static final double B3 = 0.754046;
    private static final double B4 = -0.180646;
    private static final double C1 = 1.760031;
    private static final double C2 = -0.389143;
    private static final double C3 = 0.042555;
    private static final double WIDTH_FACTOR = 2.8283;
    private static final double HEIGHT_FACTOR = 1.663374154258586;
    private Arc2D.Double arc_ = new Arc2D.Double();
    private double yA90_;
    private double yB90_;
    private double yC90_;
    private double xB90_;
    private double m90_;

    public Ginzburg4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Ginzburg4(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Ginzburg4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, 2.8283, 1.663374154258586);
    }

    protected void finishScaling() {
        double phiRad = 1.5707963267948966;
        double phiRad2 = 2.4674011002723395;
        double phiRad4 = 6.088068189625152;
        double phiRad6 = 15.021706149614129;
        this.yA90_ = this.rS_ * 1.5707963267948966;
        this.xB90_ = this.rS_ * 0.5146149382533376;
        this.yB90_ = this.rS_ * 1.0589368754462192 * 1.5707963267948966;
        double yBMinusYA = this.yB90_ - this.yA90_;
        double p = this.xB90_ * this.xB90_ + yBMinusYA * yBMinusYA;
        double q = 2.0 * yBMinusYA;
        this.m90_ = p / q;
        this.yC90_ = this.yA90_ + this.m90_;
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat == 0.0) {
            g2d.translate(this.outCenterX_, this.outCenterY_);
            GraphicUtilities.drawLine(g2d, -2.8283 * this.rS_, 0.0, 2.8283 * this.rS_, 0.0);
            g2d.translate(-this.outCenterX_, -this.outCenterY_);
            return;
        }
        double phiRad = Math.abs(Ginzburg4.toRadians(lat));
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double phiRad6 = phiRad4 * phiRad2;
        double yA = phiRad;
        double xB = 2.8283 + -1.69845 * phiRad2 + 0.754046 * phiRad4 + -0.180646 * phiRad6;
        double yB = (1.760031 + -0.389143 * phiRad2 + 0.042555 * phiRad4) * phiRad;
        double yBMinusYA = yB - yA;
        double p = xB * xB + yBMinusYA * yBMinusYA;
        double q = 2.0 * yBMinusYA;
        double m = p / q;
        double yC = yA + m;
        double alpha180 = Math.asin(xB / m);
        g2d.translate(this.outCenterX_, this.outCenterY_);
        if (lat > 0.0) {
            this.arc_.setArcByCenter(0.0, -yC * this.rS_, m * this.rS_, Ginzburg4.toDegrees(-1.5707963267948966 - alpha180), Ginzburg4.toDegrees(2.0 * alpha180), 0);
        } else {
            this.arc_.setArcByCenter(0.0, yC * this.rS_, m * this.rS_, Ginzburg4.toDegrees(1.5707963267948966 + alpha180), Ginzburg4.toDegrees(-2.0 * alpha180), 0);
        }
        g2d.draw(this.arc_);
        g2d.translate(-this.outCenterX_, -this.outCenterY_);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Ginzburg4.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double phiRad4 = phiRad2 * phiRad2;
        double phiRad6 = phiRad4 * phiRad2;
        double lambdaRad = this.lon2LambdaRad(lon);
        double x = 0.0;
        double y = 0.0;
        if (phiRad == 0.0) {
            x = 2.8283 * lambdaRad / Math.PI;
            y = 0.0;
        } else if (lambdaRad == 0.0) {
            x = 0.0;
            y = phiRad;
        } else {
            double yA = phiRad;
            double xB = 2.8283 + -1.69845 * phiRad2 + 0.754046 * phiRad4 + -0.180646 * phiRad6;
            double yB = (1.760031 + -0.389143 * phiRad2 + 0.042555 * phiRad4) * phiRad;
            double yBMinusYA = yB - yA;
            double p = xB * xB + yBMinusYA * yBMinusYA;
            double q = 2.0 * yBMinusYA;
            double m = p / q;
            double alpha180 = Math.asin(xB / m);
            double alpha = alpha180 * lambdaRad / Math.PI;
            x = m * Math.sin(alpha);
            y = yA + m - m * Math.cos(alpha);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double lambda = 0.0;
        double phi = 0.0;
        if (y == 0.0) {
            double lambdaRad = Math.PI * xOverRS / 2.8283;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
            lambda = Ginzburg4.toDegrees(lambdaRad);
            phi = 0.0;
        } else if (x == 0.0) {
            if (Math.abs(y) > this.yA90_) {
                return null;
            }
            double phiRad = yOverRS;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            lambda = 0.0;
            phi = Ginzburg4.toDegrees(phiRad);
        } else {
            double phiRad0;
            double lambdaRad0;
            double xabs = Math.abs(x);
            double yabs = Math.abs(y);
            if (yabs > this.yA90_) {
                double yyy = this.yC90_ - yabs;
                double xxx = Math.sqrt(this.m90_ * this.m90_ - yyy * yyy);
                lambdaRad0 = Math.PI * xxx / this.xB90_;
                phiRad0 = 1.5707863267948965;
            } else {
                lambdaRad0 = Math.PI * xOverRS / 2.8283;
                phiRad0 = yOverRS;
            }
            double[] llRad = this.iterateRad(xabs, yabs, lambdaRad0, phiRad0);
            if (llRad == null) {
                return null;
            }
            lambda = Ginzburg4.toDegrees(llRad[0]);
            phi = Ginzburg4.toDegrees(llRad[1]);
            if (x < 0.0) {
                lambda = -lambda;
            }
            if (y < 0.0) {
                phi = -phi;
            }
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        block0: for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double phiRad;
            double lambdaRad;
            double xx;
            double y = (double)iy + 0.5;
            if (y > this.yA90_) {
                double yy = this.yC90_ - y;
                xx = Math.sqrt(this.m90_ * this.m90_ - yy * yy);
                lambdaRad = Math.PI * xx / this.xB90_;
                phiRad = 1.5707963267948966;
            } else {
                xx = 0.0;
                lambdaRad = 0.0;
                phiRad = y * this.oneOverRS_;
            }
            for (int ix = (int)xx; ix < this.xMax_; ++ix) {
                double[] llRad;
                double x = (double)ix + 0.5;
                lambdaRad += 1.0E-5;
                phiRad += 1.0E-5;
                if (lambdaRad >= Math.PI) {
                    lambdaRad = 3.141582653589793;
                }
                if (phiRad >= 1.5707963267948966) {
                    phiRad = 1.5707863267948965;
                }
                if ((llRad = this.iterateRad(x, y, lambdaRad, phiRad)) == null) continue block0;
                lambdaRad = llRad[0];
                phiRad = llRad[1];
                this.setQSymmetricPoints(ix, iy, Ginzburg4.toDegrees(llRad[0]), Ginzburg4.toDegrees(llRad[1]));
            }
        }
    }

    private double[] iterateRad(double x, double y, double lambdaRad0, double phiRad0) {
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        int iters = 0;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad4 = phiRad2 * phiRad2;
            double phiRad6 = phiRad4 * phiRad2;
            double yA = phiRad;
            double xB = 2.8283 + -1.69845 * phiRad2 + 0.754046 * phiRad4 + -0.180646 * phiRad6;
            double yB = (1.760031 + -0.389143 * phiRad2 + 0.042555 * phiRad4) * phiRad;
            double xB2 = xB * xB;
            double dyAdPhi = 1.0;
            double dxBdPhi = (-3.3969 + 3.016184 * phiRad2 + -1.083876 * phiRad4) * phiRad;
            double dyBdPhi = 1.760031 + -1.167429 * phiRad2 + 0.21277500000000002 * phiRad4;
            double yBMinusYA = yB - yA;
            double p = xB * xB + yBMinusYA * yBMinusYA;
            double q = 2.0 * yBMinusYA;
            double m = p / q;
            double m2 = m * m;
            double dPdPhi = 2.0 * (xB * dxBdPhi + yBMinusYA * (dyBdPhi - 1.0));
            double dQdPhi = 2.0 * (dyBdPhi - 1.0);
            double dMdPhi = (dPdPhi * q - p * dQdPhi) / (q * q);
            double alpha180 = Math.asin(xB / m);
            double alpha = alpha180 * lambdaRad / Math.PI;
            double cosAlpha = Math.cos(alpha);
            double sinAlpha = Math.sin(alpha);
            double mCosAlpha = m * cosAlpha;
            double mSinAlpha = m * sinAlpha;
            double dAlphaDLambda = alpha180 / Math.PI;
            double dAlphaDPhi = lambdaRad / Math.PI * (1.0 / Math.sqrt(1.0 - xB2 / m2)) * (dxBdPhi * m - xB * dMdPhi) / m2;
            double f1 = mSinAlpha - xOverRS;
            double f2 = yA + m - mCosAlpha - yOverRS;
            double df1dPhi = dMdPhi * sinAlpha + mCosAlpha * dAlphaDPhi;
            double df1dLambda = mCosAlpha * dAlphaDLambda;
            double df2dPhi = 1.0 + dMdPhi - (dMdPhi * cosAlpha - mSinAlpha * dAlphaDPhi);
            double df2dLambda = mSinAlpha * dAlphaDLambda;
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (Math.abs(dphi) < 1.0E-5 && Math.abs(dlambda) < 1.0E-5) break;
            ++iters;
        }
        if (iters >= 25) {
            return null;
        }
        if (lambdaRad > Math.PI || lambdaRad < 0.0) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

