/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class GeneralPerspective
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "(DEVO) General Perspective";
    public static final int PROPERTIES = 131104;
    private static final double DEFAULT_R = 1.367;
    private double hFactor_;
    private double oneOverH_;
    private double hSquare_;
    private double hMinus1_;
    private double hPlus1_;
    private double rhoBorder2_;

    public GeneralPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public GeneralPerspective(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GeneralPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131104, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(new DoubleParameter("Center Distance", "Radii (R\u22650)", 1.367, 0.0, Double.POSITIVE_INFINITY, true, true));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setCenterDistance(((DoubleParameter)p).getValue());
    }

    public void setCenterDistance(double r) {
        this.hFactor_ = r;
        this.hSquare_ = this.hFactor_ * this.hFactor_;
        this.hMinus1_ = this.hFactor_ - 1.0;
        this.hPlus1_ = this.hFactor_ + 1.0;
        this.autoscale();
    }

    protected void prepareScaling() {
        this.oneOverH_ = 1.0 / this.hFactor_;
        double rhoMaxOverR = 1.0;
        if (this.hFactor_ > 1.0) {
            rhoMaxOverR = Math.sqrt(this.hPlus1_ / this.hMinus1_);
        } else if (this.hFactor_ > 0.0) {
            double maxZ = 0.9 * Math.acos(-this.oneOverH_);
            rhoMaxOverR = (this.hFactor_ + 1.0) * Math.sin(maxZ) / (this.hFactor_ + Math.cos(maxZ));
        } else {
            double maxZ = 0.7068583470577035;
            rhoMaxOverR = (this.hFactor_ + 1.0) * Math.sin(0.7068583470577035) / (this.hFactor_ + Math.cos(0.7068583470577035));
        }
        this.setSizeFactors(rhoMaxOverR, rhoMaxOverR);
    }

    protected void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = GeneralPerspective.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ < -this.oneOverH_) {
            return null;
        }
        double k = this.hPlus1_ / (this.hFactor_ + cosZ);
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double c;
        double a;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double y2 = y * y;
        double x2 = x * x;
        double rho2 = x * x + y2;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double xFactor = rho * this.oneOverRS_ / this.hMinus1_;
        double xFactor2 = xFactor * xFactor;
        double b = -2.0 * this.hFactor_ * xFactor2;
        double b2minus4ac = b * b - 4.0 * (a = xFactor2 + 1.0) * (c = xFactor2 * this.hSquare_ - 1.0);
        if (b2minus4ac < 0.0 && Math.abs(b2minus4ac) < 1.0E-5) {
            b2minus4ac = 0.0;
        }
        double cosZ = (-b + Math.sqrt(b2minus4ac)) / (2.0 * a);
        double sinZ = Math.sqrt(1.0 - cosZ * cosZ);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double phi = GeneralPerspective.toDegrees(phiRad);
        double lambda = GeneralPerspective.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        if (this.hMinus1_ <= 0.0) {
            return;
        }
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = -this.xMax_; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double rho2 = x * x + y2;
                if (rho2 > this.rhoBorder2_) continue;
                double rho = Math.sqrt(rho2);
                double xFactor = rho * this.oneOverRS_ / this.hMinus1_;
                double xFactor2 = xFactor * xFactor;
                double a = xFactor2 + 1.0;
                double b = -2.0 * this.hFactor_ * xFactor2;
                double c = xFactor2 * this.hSquare_ - 1.0;
                double cosZ = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                double sinZ = Math.sqrt(1.0 - cosZ * cosZ);
                double phiRad = Math.asin(cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho);
                double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
                this.setBiSymmetricPoints(ix, iy, GeneralPerspective.toDegrees(lambdaRad), GeneralPerspective.toDegrees(phiRad));
            }
        }
    }
}

