/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class GallStereographic
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Gall Stereographic";
    private static final double COS_PHI_TS = 0.7071067811865476;
    private static final double ONE_PLUS_COS_PHI_TS = 1.7071067811865475;
    private static final double WIDTH_FACTOR = 2.221441469079183;
    private static final double HEIGHT_FACTOR = 1.7071067811865475 * Math.tan(0.7853981633974483);
    private static final double ONE_OVER_SQRT2 = 0.7071067811865475;

    public GallStereographic(int width, int height) {
        this(width, height, 0, 0);
    }

    public GallStereographic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public GallStereographic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, 2.221441469079183, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = 0.7071067811865476 * this.lon2LambdaRad(lon);
        double y = 1.7071067811865475 * Math.tan(0.5 * GallStereographic.toRadians(lat));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.oneOverRS_ / 1.7071067811865475);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * 1.4142135623730951 * this.oneOverRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = GallStereographic.toDegrees(phiRad);
        double lambda = GallStereographic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.oneOverRS_ / 1.7071067811865475)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = GallStereographic.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.oneOverRS_ / 0.7071067811865476) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, GallStereographic.toDegrees(lambdaRad), phi);
            }
        }
    }
}

