/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.BooleanParameter;
import gov.nasa.giss.map.proj.EllipseProjection;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Fournier1
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Fournier Globular I";
    public static final int PROPERTIES = 16;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double PI2_OVER_4 = 2.4674011002723395;
    private BooleanParameter param0_ = new BooleanParameter("Global", true);
    private boolean global_ = true;

    public Fournier1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fournier1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Fournier1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.param0_);
    }

    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setGlobal(this.param0_.isSelected());
    }

    public void setGlobal(boolean b) {
        this.global_ = b;
        this.autoscale();
    }

    protected void prepareScaling() {
        if (this.global_) {
            this.setSizeFactors(Math.PI, 1.5707963267948966);
        } else {
            this.setSizeFactors(1.5707963267948966, 1.5707963267948966);
        }
    }

    protected void drawParallels(Graphics2D g2d) {
        double spacing = this.getLatGridSpacing();
        if (spacing <= 0.0) {
            return;
        }
        GraphicUtilities.drawLine(g2d, this.outCenterX_ + this.xMax_, this.outCenterY_, this.outCenterX_ - this.xMax_, this.outCenterY_);
        double add = this.global_ ? 180.0 : 90.0;
        double right = this.lambdaC_ + add - 0.001;
        Arc2D.Double arc = new Arc2D.Double();
        int steps = (int)(90.0 / spacing);
        for (int j = 1; j < steps; ++j) {
            double lat = spacing * (double)j;
            Point2D.Double dot0 = this.transformLL2XY(this.lambdaC_, lat);
            Point2D.Double dot1 = this.transformLL2XY(right, lat);
            double px = 0.5 * (dot0.x + dot1.x);
            double py = 0.5 * (dot0.y + dot1.y);
            double s1 = (dot1.y - dot0.y) / (dot1.x - dot0.x);
            double s2 = 1.0 / s1;
            double cx = this.outCenterX_;
            double cy = py - s2 * (cx - px);
            double dx = dot1.x - cx;
            double dy = dot1.y - cy;
            double d = Math.hypot(dx, dy);
            double aa = Fournier1.toDegrees(Math.acos(dx / d));
            double ee = 2.0 * (90.0 - aa);
            arc.setArcByCenter(cx, cy, d, aa + 180.0, ee, 0);
            g2d.draw(arc);
            arc.setArcByCenter(cx, 2.0 * (double)this.outCenterY_ - cy, d, aa, ee, 0);
            g2d.draw(arc);
        }
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double diff;
        double dist = this.global_ ? 180.0 : 90.0;
        for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
        }
        while (diff < 0.0) {
            diff += 360.0;
        }
        if (Math.abs(diff - dist) < 1.0E-5 || Math.abs(diff - (360.0 - dist)) < 1.0E-5) {
            return;
        }
        double yn = (double)this.outCenterY_ - Fournier1.toRadians(90.0) * this.rS_;
        double ys = (double)this.outCenterY_ - Fournier1.toRadians(-90.0) * this.rS_;
        double h = ys - yn;
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        if (dot0 == null) {
            return;
        }
        double hw = dot0.x - (double)this.outCenterX_;
        if (hw == 0.0) {
            GraphicUtilities.drawLine(g2d, this.outCenterX_, (float)yn, this.outCenterX_, (float)ys);
        } else if (hw > 0.0) {
            Arc2D.Double arc = new Arc2D.Double((double)this.outCenterX_ - hw, yn, 2.0 * hw, h, -90.0, 180.0, 0);
            g2d.draw(arc);
        } else {
            Arc2D.Double arc = new Arc2D.Double(dot0.x, yn, -2.0 * hw, h, 90.0, 180.0, 0);
            g2d.draw(arc);
        }
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = Fournier1.toRadians(lat);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        if (!this.global_ && Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        if (lambdaRad == 0.0) {
            x = 0.0;
            y = phiRad;
        } else if (phiRad == 0.0) {
            x = lambdaRad;
            y = 0.0;
        } else if (Math.abs(lambdaRad) == 1.5707963267948966) {
            x = lambdaRad * Math.cos(phiRad);
            y = 1.5707963267948966 * Math.sin(phiRad);
        } else {
            double absLambdaRad = Math.abs(lambdaRad);
            double absPhiRad = Math.abs(phiRad);
            double lambdaRad2 = lambdaRad * lambdaRad;
            double fourLambdaRad2 = 4.0 * lambdaRad2;
            double phiRad2 = phiRad * phiRad;
            double cosPhi = Math.cos(absPhiRad);
            double sinPhi = Math.sin(absPhiRad);
            double valC = 2.4674011002723395;
            double valP = Math.PI * sinPhi;
            double valS = (2.4674011002723395 - phiRad2) / (valP - 2.0 * absPhiRad);
            double valR = valS - absPhiRad;
            double sqTerm = fourLambdaRad2 * lambdaRad2 + Math.PI * 2 * lambdaRad2 * (2.0 * valS * sinPhi - Math.PI) + Math.PI * Math.PI * valR * valR;
            double cosT = (Math.PI * Math.sqrt(sqTerm) - fourLambdaRad2 * valS) / (valR * (Math.PI * Math.PI - fourLambdaRad2));
            y = valS - valR * cosT;
            x = lambdaRad * Math.sqrt(1.0 - y * y / 2.4674011002723395);
            if (phiRad < 0.0) {
                y = -y;
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double fguess;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double xOverRs = x * this.oneOverRS_;
        double yOverRs = y * this.oneOverRS_;
        double lambdaRad = xOverRs / Math.sqrt(1.0 - yOverRs * yOverRs / 2.4674011002723395);
        if (lambdaRad > Math.PI) {
            return null;
        }
        if (!this.global_ && lambdaRad > 1.5707963267948966) {
            return null;
        }
        if (y == 0.0) {
            return new PointLL(this.lambdaC_ + lambdaRad, 0.0);
        }
        double lambda = Fournier1.toDegrees(lambdaRad);
        double x2PlusY2 = xOverRs * xOverRs + yOverRs * yOverRs;
        double phiRad = fguess = Math.abs(lambda) < 30.0 ? yOverRs : Math.asin(yOverRs / Math.sqrt(x2PlusY2));
        int iters = 0;
        int iter = 0;
        while (iter < 25) {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double piSinPhi = Math.PI * sinPhi;
            double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
            double r = s - phiRad;
            double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
            double func = x2PlusY2 - 2.4674011002723395 - 2.0 * yOverRs * s + s * piSinPhi;
            double dfunc = (piSinPhi - 2.0 * yOverRs) * dsdphi + Math.PI * s * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
            iters = iter++;
        }
        double phi = Fournier1.toDegrees(phiRad);
        try {
            return new PointLL(this.lambdaC_ + lambda, phi);
        }
        catch (Exception exc) {
            System.err.println("iters " + iters + " : lambda " + lambda + " : phi " + phi + " : fguess " + Fournier1.toDegrees(fguess));
            return null;
        }
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double xOverRs;
            double lambdaRad;
            double y = (double)iy + 0.5;
            double y2 = y * y;
            double yOverRs = y * this.oneOverRS_;
            double phiRad = y / (double)this.yMax_ * 1.5707963267948966;
            for (int ix = 0; !(ix >= this.xMax_ || (lambdaRad = (xOverRs = (x = (double)ix + 0.5) * this.oneOverRS_) / Math.sqrt(1.0 - yOverRs * yOverRs / 2.4674011002723395)) > Math.PI || !this.global_ && lambdaRad > 1.5707963267948966); ++ix) {
                double x2PlusY2 = xOverRs * xOverRs + yOverRs * yOverRs;
                for (int iter = 0; iter < 25; ++iter) {
                    double cosPhi = Math.cos(phiRad);
                    double sinPhi = Math.sin(phiRad);
                    double piSinPhi = Math.PI * sinPhi;
                    double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
                    double r = s - phiRad;
                    double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
                    double func = x2PlusY2 - 2.4674011002723395 - 2.0 * yOverRs * s + s * piSinPhi;
                    double dfunc = (piSinPhi - 2.0 * yOverRs) * dsdphi + Math.PI * s * cosPhi;
                    double dphiRad = -func / dfunc;
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                this.setQSymmetricPoints(ix, iy, Fournier1.toDegrees(lambdaRad), Fournier1.toDegrees(phiRad));
            }
        }
    }
}

