/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Foucaut
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Foucaut";
    private static final double TERMP = Math.sqrt(Math.PI);
    private static final double TERMQ = 2.0;
    private static final double ONE_OVER_P = 1.0 / TERMP;
    private static final double ONE_OVER_Q = 0.5;
    private static final double Q_OVER_P = 2.0 * ONE_OVER_P;
    private static final double P_OVER_Q = TERMP * 0.5;
    private static final double WIDTH_FACTOR = Q_OVER_P * Math.PI;
    private static final double HEIGHT_FACTOR = TERMP * Math.tan(0.7853981633974483);

    public Foucaut(int width, int height) {
        this(width, height, 0, 0);
    }

    public Foucaut(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Foucaut(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Foucaut.toRadians(lat);
        double phiOverQ = phiRad * 0.5;
        double cosPhiOverQ = Math.cos(phiOverQ);
        double x = Q_OVER_P * this.lon2LambdaRad(lon) * Math.cos(phiRad) * cosPhiOverQ * cosPhiOverQ;
        double y = TERMP * Math.tan(phiOverQ);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 2.0 * Math.atan(y * this.oneOverRS_ * ONE_OVER_P);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (phiRad == 1.5707963267948966) {
            return new PointLL(this.lambdaC_, 90.0);
        }
        if (phiRad == 1.5707963267948966) {
            return new PointLL(this.lambdaC_, -90.0);
        }
        double cosPhiOverQ = Math.cos(phiRad * 0.5);
        double lambdaRad = x * this.oneOverRS_ * P_OVER_Q / Math.cos(phiRad) / (cosPhiOverQ * cosPhiOverQ);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Foucaut.toDegrees(phiRad);
        double lambda = Foucaut.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.0 * Math.atan((y = (double)iy + 0.5) * this.oneOverRS_ * ONE_OVER_P)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double xFactor;
            if (phiRad < 1.5707963267948966) {
                double cosPhiOverQ = Math.cos(phiRad * 0.5);
                xFactor = this.oneOverRS_ * P_OVER_Q / Math.cos(phiRad) / (cosPhiOverQ * cosPhiOverQ);
            } else {
                xFactor = 0.0;
            }
            double phi = Foucaut.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Foucaut.toDegrees(lambdaRad), phi);
            }
        }
    }
}

