/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Fahey
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Fahey";
    private static final double COS35 = Math.cos(0.6108652381980153);
    private static final double ONE_PLUS_COS35 = 1.0 + COS35;
    private static final double WIDTH_FACTOR = Math.PI * COS35;
    private static final double HEIGHT_FACTOR = ONE_PLUS_COS35;

    public Fahey(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fahey(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Fahey(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawCurveBorder(g2d, this, this.outCenterX_, this.outCenterY_);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double halfPhiRad = 0.5 * Fahey.toRadians(lat);
        double tanHalfPhiRad = Math.tan(halfPhiRad);
        double x = this.lon2LambdaRad(lon) * COS35 * Math.sqrt(1.0 - tanHalfPhiRad * tanHalfPhiRad);
        double y = ONE_PLUS_COS35 * tanHalfPhiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double tanHalfPhiRad = yOverRS / ONE_PLUS_COS35;
        double phiRad = 2.0 * Math.atan(tanHalfPhiRad);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = xOverRS / COS35 / Math.sqrt(1.0 - tanHalfPhiRad * tanHalfPhiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Fahey.toDegrees(phiRad);
        double lambda = Fahey.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double yOverRS;
        double tanHalfPhiRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = 2.0 * Math.atan(tanHalfPhiRad = (yOverRS = (y = (double)iy + 0.5) * this.oneOverRS_) / ONE_PLUS_COS35)) > 1.5707963267948966); ++iy) {
            double phi = Fahey.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / COS35 / Math.sqrt(1.0 - tanHalfPhiRad * tanHalfPhiRad);
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, Fahey.toDegrees(lambdaRad), phi);
            }
        }
    }
}

