/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjParameterListener;
import javax.swing.event.EventListenerList;

public abstract class ExtraParameter {
    protected AbstractProjection parent_;
    protected String name_;
    protected String units_;
    private EventListenerList listenerList_ = new EventListenerList();

    public ExtraParameter(String name, String units) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter must have a name.");
        }
        this.name_ = name;
        this.units_ = units;
    }

    public void setParent(AbstractProjection parent) {
        this.parent_ = parent;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public abstract Object getDefaultObject();

    public abstract Object getValueObject();

    public abstract void setValue(Object var1) throws IllegalArgumentException;

    public abstract void setValue(String var1) throws IllegalArgumentException;

    public String getUnits() {
        return this.units_;
    }

    public void setUnits(String units) {
        this.units_ = units;
    }

    public abstract void reset();

    public synchronized ProjParameterListener[] getParameterListeners() {
        ProjParameterListener[] listeners = (ProjParameterListener[])this.listenerList_.getListeners(ProjParameterListener.class);
        return listeners;
    }

    public synchronized void addParameterListener(ProjParameterListener l) {
        this.listenerList_.add(ProjParameterListener.class, l);
    }

    public synchronized void removeParameterListener(ProjParameterListener l) {
        this.listenerList_.remove(ProjParameterListener.class, l);
    }

    public void fireChange() {
        ProjParameterListener[] listeners;
        ProjParameterEvent e = new ProjParameterEvent(this);
        for (ProjParameterListener l : listeners = this.getParameterListeners()) {
            l.parameterChanged(e);
        }
    }
}

