/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class ErdiKrausz
extends QuadSymmetricProjection {
    public static final String PROJECTION_NAME = "\u00c9rdi-Krausz";
    public static final int PROPERTIES = 262148;
    private static final double JOIN_LAT = 60.0;
    private static final double YSHIFT = 0.28549;
    private static final double CXE = 0.96042;
    private static final double CXP = 1.07023;
    private static final double CYE = 1.30152;
    private static final double CYP = 1.68111;
    private static final double WIDTH_FACTOR = 3.0172484163607094;
    private static final double HEIGHT_FACTOR = 1.39562;
    private double joinY_;

    public ErdiKrausz(int width, int height) {
        this(width, height, 0, 0);
    }

    public ErdiKrausz(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public ErdiKrausz(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 262148, width, height, xmargin, ymargin, 3.0172484163607094, 1.39562);
        this.autoscale();
    }

    protected void finishScaling() {
        Point2D.Double joinPt = this.transformLL2XYIgnoreMargins(0.0, 60.0);
        this.joinY_ = (double)this.outCenterY_ - joinPt.y;
    }

    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawCurveBorder(g2d, this, this.outCenterX_, this.outCenterY_);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.39562 * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.39562 * this.rS_);
        }
        double x = this.lon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 60.0) {
            double phiTerm = Math.PI * Math.sin(ErdiKrausz.toRadians(lat));
            double thetaRad = ErdiKrausz.toRadians(lat);
            for (int iter = 0; iter < 25; ++iter) {
                double twoThetaRad = 2.0 * thetaRad;
                double func = twoThetaRad + Math.sin(twoThetaRad) - phiTerm;
                double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= 1.07023 * Math.cos(thetaRad);
            y = lat > 0.0 ? (y *= 1.68111 * Math.sin(thetaRad) - 0.28549) : (y *= 1.68111 * Math.sin(thetaRad) + 0.28549);
        } else {
            double thetaRad = Math.asin(0.8 * Math.sin(ErdiKrausz.toRadians(lat)));
            x *= 0.96042 * Math.cos(thetaRad);
            y *= 1.30152 * thetaRad;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = 0.0;
        double xFactor = 0.0;
        if (Math.abs(y) > this.joinY_) {
            double sinTheta = (Math.abs(y) * this.oneOverRS_ + 0.28549) / 1.68111;
            double thetaRad = Math.asin(sinTheta);
            phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) / Math.PI);
            xFactor = this.oneOverRS_ / (1.07023 * Math.cos(thetaRad));
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
        } else {
            double thetaRad = y * this.oneOverRS_ / 1.30152;
            phiRad = Math.asin(Math.sin(thetaRad) / 0.8);
            xFactor = this.oneOverRS_ / (0.96042 * Math.cos(thetaRad));
        }
        double lambdaRad = x * xFactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = ErdiKrausz.toDegrees(phiRad);
        double lambda = ErdiKrausz.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = 0; iy < this.yMax_; ++iy) {
            double x;
            double lambdaRad;
            double xFactor;
            double phiRad;
            double thetaRad;
            double y = (double)iy + 0.5;
            if (y > this.joinY_) {
                double sinTheta = (y += 0.28549 * this.rS_) * this.oneOverRS_ / 1.68111;
                thetaRad = Math.asin(sinTheta);
                phiRad = Math.asin((2.0 * thetaRad + Math.sin(2.0 * thetaRad)) / Math.PI);
                xFactor = this.oneOverRS_ / (1.07023 * Math.cos(thetaRad));
                if (phiRad > 1.5707963267948966) {
                    break;
                }
            } else {
                thetaRad = y * this.oneOverRS_ / 1.30152;
                phiRad = Math.asin(Math.sin(thetaRad) / 0.8);
                xFactor = this.oneOverRS_ / (0.96042 * Math.cos(thetaRad));
            }
            double phi = ErdiKrausz.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, ErdiKrausz.toDegrees(lambdaRad), phi);
            }
        }
    }
}

