/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class EquirectangularRegional
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Equirectangular (Regional)";
    public static final int PROPERTIES = 131074;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double xPxlPerDeg_ = 1.0;
    private double yPxlPerDeg_ = 1.0;
    private double xDegPerPxl_ = 1.0;
    private double yDegPerPxl_ = 1.0;
    private double widthDeg_ = 1.0;
    private double heightDeg_ = 1.0;
    private float lMargin_;
    private float rMargin_;
    private float tMargin_;
    private float bMargin_;
    private Path2D.Double path_;

    public EquirectangularRegional(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public EquirectangularRegional(int width, int height) {
        this(width, height, 0, 0);
    }

    public EquirectangularRegional(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131074, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(new DoubleParameter("Width", "\u00b0", 90.0, 0.002, 360.0, true, true));
        this.addParameter(new DoubleParameter("Height", "\u00b0", 45.0, 0.002, 180.0, true, true));
        this.parameterChanged(null);
        this.path_ = new Path2D.Double();
    }

    public boolean canLabelGrid() {
        return true;
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p = e == null ? null : (ExtraParameter)e.getSource();
        DoubleParameter wp = (DoubleParameter)this.getParameter(0);
        DoubleParameter hp = (DoubleParameter)this.getParameter(1);
        this.widthDeg_ = wp.getValue();
        this.heightDeg_ = hp.getValue();
        this.autoscale();
    }

    public double getWidth() {
        return this.widthDeg_;
    }

    public void setWidth(double w) {
        this.widthDeg_ = w;
        this.autoscale();
    }

    public double getHeight() {
        return this.heightDeg_;
    }

    public void setHeight(double h) {
        this.heightDeg_ = h;
        this.autoscale();
    }

    public boolean isRecenterableLat() {
        return true;
    }

    protected void finishScaling() {
        Dimension ms = this.getMarginSize();
        this.xPxlPerDeg_ = ((double)this.outWidth_ - 2.0 * ms.getWidth()) / this.widthDeg_;
        this.yPxlPerDeg_ = ((double)this.outHeight_ - 2.0 * ms.getHeight()) / this.heightDeg_;
        this.xDegPerPxl_ = 1.0 / this.xPxlPerDeg_;
        this.yDegPerPxl_ = 1.0 / this.yPxlPerDeg_;
        this.lMargin_ = ms.width;
        this.rMargin_ = this.outWidth_ - ms.width;
        this.tMargin_ = ms.height;
        this.bMargin_ = this.outHeight_ - ms.height;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (lat < -90.0 || lat > 90.0) {
            return null;
        }
        double x = EquirectangularRegional.normalizeLon180(lon - this.lambdaC_) * this.xPxlPerDeg_;
        double y = -(lat - this.phiC_) * this.yPxlPerDeg_;
        y += (double)this.outCenterY_;
        if ((x += (double)this.outCenterX_) < (double)this.lMargin_ || x > (double)this.rMargin_) {
            return null;
        }
        if (y < (double)this.tMargin_ || y > (double)this.bMargin_) {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phi = this.phiC_ + y * this.yDegPerPxl_;
        if (phi < -90.0 || phi > 90.0) {
            return null;
        }
        double lambda = x * this.xDegPerPxl_;
        if (lambda < -180.0 || lambda > 180.0) {
            return null;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double copLat = this.phiC_;
        Dimension ms = this.getMarginSize();
        int maxdx = (int)(((double)this.outWidth_ - 2.0 * ms.getWidth()) / 2.0);
        int maxdy = (int)(((double)this.outHeight_ - 2.0 * ms.getHeight()) / 2.0);
        for (int iy = -maxdy; iy < maxdy; ++iy) {
            double x;
            double lambda;
            double y = (double)iy + 0.5;
            double phi = copLat + y * this.yDegPerPxl_;
            if (phi < -90.0) continue;
            if (phi > 90.0) break;
            for (int ix = 0; ix < maxdx && !((lambda = (x = (double)ix + 0.5) * this.xDegPerPxl_) > 180.0); ++ix) {
                this.setBiSymmetricPoints(ix, iy, lambda, phi);
            }
        }
    }

    protected void setBiSymmetricPoints(int ix, int iy, double lambda, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_ || colF < 0 || colF >= this.outWidth_) {
            return;
        }
        int indexR = row * this.outWidth_ + col;
        int indexL = row * this.outWidth_ + colF;
        this.invArrayLon_[indexR] = EquirectangularRegional.normalizeLon360(this.lambdaC_ + lambda);
        this.invArrayLon_[indexL] = EquirectangularRegional.normalizeLon360(this.lambdaC_ - lambda);
        this.invArrayLat_[indexR] = phi;
        this.invArrayLat_[indexL] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1) {
            int srcXF;
            int srcX = this.getSrcPixelX(this.lambdaC_ + lambda);
            if (srcX > -1) {
                this.invArray_[indexR] = srcY * this.srcWidth_ + srcX;
            }
            if ((srcXF = this.getSrcPixelX(this.lambdaC_ - lambda)) > -1) {
                this.invArray_[indexL] = srcY * this.srcWidth_ + srcXF;
            }
        }
    }

    protected void drawBorderLines(Graphics2D g2d) {
        BasicStroke bstroke;
        Stroke ostroke = g2d.getStroke();
        if (ostroke instanceof BasicStroke && ((bstroke = (BasicStroke)ostroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2d.setStroke(new BasicStroke(bstroke.getLineWidth(), 2, 0));
        }
        Point2D.Double np = this.transformLL2XY(this.lambdaC_, 90.0);
        Point2D.Double sp = this.transformLL2XY(this.lambdaC_, -90.0);
        float top = np == null || np.y < (double)this.tMargin_ ? this.tMargin_ : (float)np.y;
        float bottom = sp == null || sp.y > (double)this.bMargin_ ? this.bMargin_ : (float)sp.y;
        this.path_.reset();
        this.path_.moveTo(this.lMargin_, top);
        this.path_.lineTo(this.lMargin_, bottom);
        this.path_.lineTo(this.rMargin_, bottom);
        this.path_.lineTo(this.rMargin_, top);
        this.path_.closePath();
        g2d.draw(this.path_);
        g2d.setStroke(ostroke);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_, lat);
        if (dot == null) {
            return;
        }
        if (dot.y <= (double)this.tMargin_ + 0.5) {
            return;
        }
        if (dot.y >= (double)this.bMargin_ - 0.5) {
            return;
        }
        if (label == null) {
            GraphicUtilities.drawLine(g2d, this.lMargin_, (float)dot.y, this.rMargin_, (float)dot.y);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int a = fm.getAscent();
        float x = this.rMargin_ - 3.0f - 2.0f - (float)w;
        GraphicUtilities.drawLine(g2d, this.lMargin_, (float)dot.y, x - 2.0f, (float)dot.y);
        GraphicUtilities.drawString(g2d, label, x, (float)(dot.y + 0.5 * (double)a));
        GraphicUtilities.drawLine(g2d, x + (float)w + 2.0f, (float)dot.y, this.rMargin_, (float)dot.y);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        float bottom;
        Point2D.Double dot = this.transformLL2XY(lon, this.phiC_);
        if (dot == null) {
            return;
        }
        if (dot.x <= (double)this.lMargin_ + 0.5) {
            return;
        }
        if (dot.x >= (double)this.rMargin_ - 0.5) {
            return;
        }
        Point2D.Double np = this.transformLL2XY(this.lambdaC_, 90.0);
        Point2D.Double sp = this.transformLL2XY(this.lambdaC_, -90.0);
        float top = np == null || np.y < (double)this.tMargin_ ? this.tMargin_ : (float)np.y;
        float f = bottom = sp == null || sp.y > (double)this.bMargin_ ? this.bMargin_ : (float)sp.y;
        if (label == null) {
            GraphicUtilities.drawLine(g2d, (float)dot.x, top, (float)dot.x, bottom);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int a = fm.getAscent();
        float x = (float)(dot.x - 0.5 * (double)w);
        if ((double)x < (double)this.lMargin_ + 0.5) {
            x = (float)((double)this.lMargin_ + 0.5);
        } else if ((double)(x + (float)w) >= (double)this.rMargin_ - 0.5) {
            x = (float)((double)this.rMargin_ - 0.5 - (double)w);
        }
        GraphicUtilities.drawLine(g2d, (float)dot.x, top, (float)dot.x, bottom - 5.0f - (float)a);
        GraphicUtilities.drawString(g2d, label, x, (float)(dot.y + (double)this.yMax_ - 5.0 - 1.0));
        GraphicUtilities.drawLine(g2d, (float)dot.x, bottom - 5.0f + 1.0f, (float)dot.x, bottom);
    }
}

