/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class EquirectangularOblique
extends BiSymmetricProjection {
    public static final String PROJECTION_NAME = "Equirectangular Oblique";
    public static final int PROPERTIES = 131074;
    private static final double DEFAULT_PHITS = 0.0;
    private static final double COS_PHITS = 1.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    protected static final double DEFAULT_HEIGHT = 180.0;
    private boolean needsRotate_ = true;
    private double[][] rotY_ = new double[3][3];
    private double[][] rotZ_ = new double[3][3];
    private Path2D.Double path_ = new Path2D.Double();
    private double heightDeg_ = 180.0;

    public EquirectangularOblique(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public EquirectangularOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131074, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(new DoubleParameter("Height", "\u00b0", 180.0, 0.002, 180.0, true, true));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p != null && p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setHeight(((DoubleParameter)p).getValue());
    }

    public void setHeight(double height) {
        this.heightDeg_ = height;
        this.autoscale();
    }

    protected void prepareScaling() {
        double ratio = this.heightDeg_ / 180.0;
        this.setSizeFactors(ratio * Math.PI, ratio * 1.5707963267948966);
    }

    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.needsRotate_ = true;
    }

    protected void drawBorderLines(Graphics2D g2d) {
        BasicStroke bstroke;
        Stroke ostroke = g2d.getStroke();
        if (ostroke instanceof BasicStroke && ((bstroke = (BasicStroke)ostroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2d.setStroke(new BasicStroke(bstroke.getLineWidth(), 2, 0));
        }
        this.path_.reset();
        this.path_.moveTo(this.outCenterX_ - this.xMax_, this.outCenterY_ - this.yMax_);
        this.path_.lineTo(this.outCenterX_ - this.xMax_, this.outCenterY_ + this.yMax_);
        this.path_.lineTo(this.outCenterX_ + this.xMax_, this.outCenterY_ + this.yMax_);
        this.path_.lineTo(this.outCenterX_ + this.xMax_, this.outCenterY_ - this.yMax_);
        this.path_.closePath();
        g2d.draw(this.path_);
        g2d.setStroke(ostroke);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        PointLL ll = this.transformReal2Rot(lon, lat);
        double x = EquirectangularOblique.toRadians(ll.getLon());
        double y = EquirectangularOblique.toRadians(ll.getLat());
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double rlon = EquirectangularOblique.toDegrees(x * this.oneOverRS_);
        double rlat = EquirectangularOblique.toDegrees(y * this.oneOverRS_);
        if (Math.abs(rlon) > 90.0) {
            return null;
        }
        if (Math.abs(rlat) > 180.0) {
            return null;
        }
        return this.transformRot2Real(rlon, rlat);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double rlat;
        for (int iy = -this.yMax_; iy < this.yMax_ && !(Math.abs(rlat = EquirectangularOblique.toDegrees((y = (double)iy + 0.5) * this.oneOverRS_)) > 90.0); ++iy) {
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double rlon = EquirectangularOblique.toDegrees(x * this.oneOverRS_);
                PointLL ll = this.transformRot2Real(rlon, rlat);
                this.setBiSymmetricPoints(ix, iy, ll.getLon() - this.lambdaC_, ll.getLat());
            }
        }
    }

    public PointLL transformReal2Rot(double lon, double lat) {
        if (this.needsRotate_) {
            this.rotate();
        }
        double lonRad = EquirectangularOblique.toRadians(lon);
        double phiRad = EquirectangularOblique.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double[] p0 = new double[]{cosPhi * Math.cos(lonRad), cosPhi * Math.sin(lonRad), sinPhi};
        double[] p1 = new double[]{this.rotZ_[0][0] * p0[0] + this.rotZ_[0][1] * p0[1], this.rotZ_[1][0] * p0[0] + this.rotZ_[1][1] * p0[1], p0[2]};
        double[] p2 = new double[]{this.rotY_[0][0] * p1[0] + this.rotY_[0][2] * p1[2], p1[1], this.rotY_[2][0] * p1[0] + this.rotY_[2][2] * p1[2]};
        double lon2 = EquirectangularOblique.toDegrees(Math.atan2(p2[1], p2[0]));
        double lat2 = EquirectangularOblique.toDegrees(Math.asin(p2[2]));
        return new PointLL(lon2, lat2);
    }

    public PointLL transformRot2Real(double lon, double lat) {
        if (this.needsRotate_) {
            this.rotate();
        }
        double lonRad = EquirectangularOblique.toRadians(lon);
        double phiRad = EquirectangularOblique.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double[] p0 = new double[]{cosPhi * Math.cos(lonRad), cosPhi * Math.sin(lonRad), sinPhi};
        double[] p1 = new double[]{this.rotY_[0][0] * p0[0] + this.rotY_[2][0] * p0[2], p0[1], this.rotY_[0][2] * p0[0] + this.rotY_[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotZ_[0][0] * p1[0] + this.rotZ_[1][0] * p1[1], this.rotZ_[0][1] * p1[0] + this.rotZ_[1][1] * p1[1], p1[2]};
        double lon2 = EquirectangularOblique.toDegrees(Math.atan2(p2[1], p2[0]));
        double lat2 = EquirectangularOblique.toDegrees(Math.asin(p2[2]));
        return new PointLL(lon2, lat2);
    }

    private void rotate() {
        this.autoscale();
        double betaRad = EquirectangularOblique.toRadians(this.phiC_);
        double gammaRad = -EquirectangularOblique.toRadians(this.lambdaC_);
        double cosBeta = Math.cos(betaRad);
        double sinBeta = Math.sin(betaRad);
        double cosGamma = Math.cos(gammaRad);
        double sinGamma = Math.sin(gammaRad);
        this.rotY_[0][0] = cosBeta;
        this.rotY_[0][1] = 0.0;
        this.rotY_[0][2] = sinBeta;
        this.rotY_[1][0] = 0.0;
        this.rotY_[1][1] = 1.0;
        this.rotY_[1][2] = 0.0;
        this.rotY_[2][0] = -sinBeta;
        this.rotY_[2][1] = 0.0;
        this.rotY_[2][2] = cosBeta;
        this.rotZ_[0][0] = cosGamma;
        this.rotZ_[0][1] = -sinGamma;
        this.rotZ_[0][2] = 0.0;
        this.rotZ_[1][0] = sinGamma;
        this.rotZ_[1][1] = cosGamma;
        this.rotZ_[1][2] = 0.0;
        this.rotZ_[2][0] = 0.0;
        this.rotZ_[2][1] = 0.0;
        this.rotZ_[2][2] = 1.0;
        this.needsRotate_ = false;
    }
}

