/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Equirectangular
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Equirectangular";
    private static final double DEFAULT_PHITS = 0.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double cosPhiTS_ = Math.cos(Equirectangular.toRadians(0.0));

    public Equirectangular(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Equirectangular(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(new DoubleParameter("Std. Parallel", "\u00b0", 0.0, 0.0, 90.0, true, false));
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(((DoubleParameter)p).getValue());
    }

    public void setStandardParallel(double lat) {
        this.cosPhiTS_ = Math.cos(Equirectangular.toRadians(lat));
        this.autoscale();
    }

    protected void prepareScaling() {
        double xMaxOverR = Math.PI * this.cosPhiTS_;
        this.setSizeFactors(xMaxOverR, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.cosPhiTS_ * this.lon2LambdaRad(lon);
        double y = -Equirectangular.toRadians(lat);
        return new Point2D.Double((double)this.outCenterX_ + x * this.rS_, (double)this.outCenterY_ + y * this.rS_);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / this.cosPhiTS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Equirectangular.toDegrees(phiRad);
        double lambda = Equirectangular.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double oneOverRScosPhiTS_ = this.oneOverRS_ / this.cosPhiTS_;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Equirectangular.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * oneOverRScosPhiTS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Equirectangular.toDegrees(lambdaRad), phi);
            }
        }
    }
}

