/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ConicProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class EquidistantConic
extends ConicProjection {
    public static final String PROJECTION_NAME = "Equidistant Conic";
    public static final int PROPERTIES = 131080;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.PI;
    private double termN_;
    private double oneOverN_;
    private double termF_;
    private double rho0_;

    public EquidistantConic(int width, int height) {
        this(width, height, 0, 0);
    }

    public EquidistantConic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public EquidistantConic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131080, width, height, xmargin, ymargin, Math.PI, Math.PI);
        this.autoscale();
    }

    protected void prepareScaling() {
        double phi1Rad = EquidistantConic.toRadians(this.phi1_);
        double phi2Rad = EquidistantConic.toRadians(this.phi2_);
        double cosPhi1 = Math.cos(phi1Rad);
        double cosPhi2 = Math.cos(phi2Rad);
        if (this.phi1_ == this.phi2_) {
            this.termN_ = this.phi1_ >= 0.0 ? 1.0 : -1.0;
            this.termF_ = 1.0 / Math.tan(phi1Rad) + phi1Rad;
        } else {
            this.termN_ = (cosPhi1 - cosPhi2) / (phi2Rad - phi1Rad);
            this.termF_ = (phi2Rad * cosPhi1 - phi1Rad * cosPhi2) / (cosPhi1 - cosPhi2);
        }
        this.oneOverN_ = 1.0 / this.termN_;
        this.rho0_ = this.termF_ - EquidistantConic.toRadians(this.phiC_);
        double dPhi = this.phiHeight_;
        double phiTRad = Math.min(90.0, this.phiC_ + 0.5 * dPhi) * (Math.PI / 180);
        double phiBRad = Math.max(-90.0, this.phiC_ - 0.5 * dPhi) * (Math.PI / 180);
        double sinPhiT = Math.sin(phiTRad);
        double sinPhiB = Math.sin(phiBRad);
        double lambdaRad1 = 0.0;
        double lambdaRad2 = 0.5 * EquidistantConic.toRadians(dPhi);
        double rhoT = this.termF_ - phiTRad;
        double rhoB = this.termF_ - phiBRad;
        double theta1 = this.termN_ * 0.0;
        double theta2 = this.termN_ * lambdaRad2;
        double xT1 = rhoT * Math.sin(theta1);
        double xT2 = rhoT * Math.sin(theta2);
        double xB1 = rhoB * Math.sin(theta1);
        double xB2 = rhoB * Math.sin(theta2);
        double yT1 = this.rho0_ - rhoT * Math.cos(theta1);
        double yT2 = this.rho0_ - rhoT * Math.cos(theta2);
        double yB1 = this.rho0_ - rhoB * Math.cos(theta1);
        double yB2 = this.rho0_ - rhoB * Math.cos(theta2);
        double yT = yT2 > yB2 ? Math.max(yT1, yT2) : Math.max(yT1, yB2);
        double yB = yT2 > yB2 ? Math.min(yB1, yB2) : Math.min(yB1, yT2);
        double xMaxOverR = Math.max(xT2, xB2);
        double yMaxOverR = Math.max(Math.abs(yT), Math.abs(yB));
        this.setSizeFactors(xMaxOverR, yMaxOverR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = EquidistantConic.toRadians(lat);
        double rho = this.termF_ - phiRad;
        double theta = this.termN_ * lambdaRad;
        double x = rho * Math.sin(theta);
        double y = this.rho0_ - rho * Math.cos(theta);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double xOverRS = x * this.oneOverRS_;
        double yOverRS = y * this.oneOverRS_;
        double rho0_MinusYOverRS = this.rho0_ - yOverRS;
        double rho = Math.sqrt(xOverRS * xOverRS + rho0_MinusYOverRS * rho0_MinusYOverRS);
        if (this.termN_ < 0.0) {
            rho = -rho;
        }
        if (Math.abs(phiRad = this.termF_ - rho) > 1.5707963267948966) {
            return null;
        }
        double theta = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0_MinusYOverRS) : Math.atan2(xOverRS, rho0_MinusYOverRS);
        double lambdaRad = theta * this.oneOverN_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = EquidistantConic.toDegrees(phiRad);
        double lambda = EquidistantConic.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        for (int iy = -this.yMax_; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            double yOverRS = y * this.oneOverRS_;
            double rho0_MinusYOverRS = this.rho0_ - yOverRS;
            double rho0_MinusYOverRSSq = rho0_MinusYOverRS * rho0_MinusYOverRS;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double theta;
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                double rho = Math.sqrt(xOverRS * xOverRS + rho0_MinusYOverRSSq);
                if (this.termN_ < 0.0) {
                    rho = -rho;
                }
                if (Math.abs(phiRad = this.termF_ - rho) > 1.5707963267948966 || (lambdaRad = (theta = this.termN_ < 0.0 ? Math.atan2(-xOverRS, -rho0_MinusYOverRS) : Math.atan2(xOverRS, rho0_MinusYOverRS)) * this.oneOverN_) > Math.PI) continue;
                this.setBiSymmetricPoints(ix, iy, EquidistantConic.toDegrees(lambdaRad), EquidistantConic.toDegrees(phiRad));
            }
        }
    }
}

