/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PointPoleProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class EckertGreifendorff
extends PointPoleProjection {
    public static final String PROJECTION_NAME = "Eckert-Greifendorff";
    public static final int PROPERTIES = 16;
    private static final double CW = 0.25;
    private static final double ONE_OVER_CW = 4.0;
    private static final double WIDTH_FACTOR = 4.0 * Math.sin(0.7853981633974483) * Math.sqrt(2.0 / (1.0 + Math.cos(0.7853981633974483)));
    private static final double HEIGHT_FACTOR = 1.4142135623730951;

    public EckertGreifendorff(int width, int height) {
        this(width, height, 0, 0);
    }

    public EckertGreifendorff(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public EckertGreifendorff(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 16, width, height, xmargin, ymargin, WIDTH_FACTOR, 1.4142135623730951);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double cwLambdaRad = 0.25 * this.lon2LambdaRad(lon);
        double phiRad = EckertGreifendorff.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double k = Math.sqrt(2.0 / (1.0 + cosPhi * Math.cos(cwLambdaRad)));
        double x = 4.0 * k * cosPhi * Math.sin(cwLambdaRad);
        double y = k * sinPhi;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double a = Math.hypot(0.25 * x, y);
        double c = 2.0 * Math.asin(a * 0.5 * this.oneOverRS_);
        double sinC = Math.sin(c);
        double cosC = Math.cos(c);
        double phiRad = Math.asin(y * sinC / a);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = 4.0 * Math.atan2(0.25 * x * sinC, a * cosC);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = EckertGreifendorff.toDegrees(phiRad);
        double lambda = EckertGreifendorff.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        block0: for (int iy = 0; iy < this.yMax_; ++iy) {
            double y = (double)iy + 0.5;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double a = Math.hypot(0.25 * x, y);
                double c = 2.0 * Math.asin(a * 0.5 * this.oneOverRS_);
                double sinC = Math.sin(c);
                double cosC = Math.cos(c);
                double phiRad = Math.asin(y * sinC / a);
                if (phiRad > 1.5707963267948966) continue block0;
                double lambdaRad = 4.0 * Math.atan2(0.25 * x * sinC, a * cosC);
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, EckertGreifendorff.toDegrees(lambdaRad), EckertGreifendorff.toDegrees(phiRad));
            }
        }
    }
}

