/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Eckert6
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Eckert VI";
    private static final double CONST_A = 1.0 / Math.sqrt(5.141592653589793);
    private static final double ONE_OVER_A = 1.0 / CONST_A;
    private static final double ONE_PLUS_HALF_PI = 2.5707963267948966;
    private static final double WIDTH_FACTOR = Math.PI * 2 * CONST_A;
    private static final double HEIGHT_FACTOR = Math.PI * CONST_A;

    public Eckert6(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert6(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Eckert6(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Eckert6.toRadians(lat);
        double phiFactor = 2.5707963267948966 * Math.sin(phiRad);
        double thetaRad = phiRad;
        for (int iter = 0; iter < 25; ++iter) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double func = thetaRad + sinTheta - phiFactor;
            double dfunc = 1.0 + cosTheta;
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double x = CONST_A * lambdaRad * (1.0 + Math.cos(thetaRad));
        double y = 2.0 * CONST_A * thetaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = 0.5 * y * this.oneOverRS_ * ONE_OVER_A;
        double phiRad = Math.asin((thetaRad + Math.sin(thetaRad)) / 2.5707963267948966);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / (CONST_A * (1.0 + Math.cos(thetaRad)));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Eckert6.toDegrees(phiRad);
        double lambda = Eckert6.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double sinTheta;
        double y;
        double thetaRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(((thetaRad = 0.5 * (y = (double)iy + 0.5) * this.oneOverRS_ * ONE_OVER_A) + (sinTheta = Math.sin(thetaRad))) / 2.5707963267948966)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert6.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ / (CONST_A * (1.0 + Math.cos(thetaRad)));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert6.toDegrees(lambdaRad), phi);
            }
        }
    }
}

