/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Eckert5
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Eckert V";
    private static final double CONST_A = 1.0 / Math.sqrt(5.141592653589793);
    private static final double ONE_OVER_A = 1.0 / CONST_A;
    private static final double WIDTH_FACTOR = 2.0 * CONST_A * Math.PI;
    private static final double HEIGHT_FACTOR = CONST_A * Math.PI;
    private double sqrt2PiOver2RS_;

    public Eckert5(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert5(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Eckert5(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = Eckert5.toRadians(lat);
        double x = CONST_A * lambdaRad * (1.0 + Math.cos(phiRad));
        double y = 2.0 * CONST_A * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * 0.5 * this.oneOverRS_ * ONE_OVER_A;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ * ONE_OVER_A / (1.0 + Math.cos(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Eckert5.toDegrees(phiRad);
        double lambda = Eckert5.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * 0.5 * this.oneOverRS_ * ONE_OVER_A) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert5.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ * ONE_OVER_A / (1.0 + Math.cos(phiRad));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert5.toDegrees(lambdaRad), phi);
            }
        }
    }
}

