/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Eckert4
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Eckert IV";
    private static final double CONST_A = 2.0 / Math.sqrt(22.43597501544853);
    private static final double ONE_OVER_A = 1.0 / CONST_A;
    private static final double ONE_OVER_PI_A = 1.0 / (Math.PI * CONST_A);
    private static final double HALF_PI_A2 = 1.5707963267948966 * CONST_A * CONST_A;
    private static final double TWO_PLUS_HALF_PI = 3.5707963267948966;
    private static final double WIDTH_FACTOR = Math.PI * 2 * CONST_A;
    private static final double HEIGHT_FACTOR = Math.PI * CONST_A;

    public Eckert4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert4(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Eckert4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double diff;
        for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
        }
        while (diff < 0.0) {
            diff += 360.0;
        }
        if (Math.abs(diff - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
        if (dot0 == null) {
            return;
        }
        double hw = dot0.x - dotN.x;
        double h = dotS.y - dotN.y;
        if (hw == 0.0) {
            GraphicUtilities.drawLine(g2d, (float)dotN.x, (float)dotN.y, (float)dotS.x, (float)dotS.y);
        } else if (hw > 0.0) {
            g2d.draw(new Arc2D.Double(dotN.x - hw, dotN.y, 2.0 * hw, h, -90.0, 180.0, 0));
        } else {
            g2d.draw(new Arc2D.Double(dot0.x, dotN.y, -2.0 * hw, h, 90.0, 180.0, 0));
        }
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiFactor = 3.5707963267948966 * Math.sin(Eckert4.toRadians(lat));
        double thetaRad = 0.5 * Eckert4.toRadians(lat);
        for (int iter = 0; iter < 25; ++iter) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double func = thetaRad + sinTheta * (2.0 + cosTheta) - phiFactor;
            double dfunc = 2.0 * cosTheta * (1.0 + cosTheta);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double x = CONST_A * lambdaRad * (1.0 + Math.cos(thetaRad));
        double y = Math.PI * CONST_A * Math.sin(thetaRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double cosTheta;
        double sinTheta;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double thetaRad = Math.asin(y * this.oneOverRS_ * ONE_OVER_PI_A);
        double phiRad = Math.asin((thetaRad + (sinTheta = Math.sin(thetaRad)) * (2.0 + (cosTheta = Math.cos(thetaRad)))) * HALF_PI_A2);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ * ONE_OVER_A / (1.0 + cosTheta);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Eckert4.toDegrees(phiRad);
        double lambda = Eckert4.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double cosTheta;
        double sinTheta;
        double y;
        double thetaRad;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin(((thetaRad = Math.asin((y = (double)iy + 0.5) * this.oneOverRS_ * ONE_OVER_PI_A)) + (sinTheta = Math.sin(thetaRad)) * (2.0 + (cosTheta = Math.cos(thetaRad)))) * HALF_PI_A2)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert4.toDegrees(phiRad);
            double xFactor = this.oneOverRS_ * ONE_OVER_A / (1.0 + cosTheta);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert4.toDegrees(lambdaRad), phi);
            }
        }
    }
}

