/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Eckert3
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Eckert III";
    private static final double CONST_A = 2.0 / Math.sqrt(22.43597501544853);
    private static final double ONE_OVER_A = 1.0 / CONST_A;
    private static final double TWO_OVER_PI = 0.6366197723675814;
    private static final double WIDTH_FACTOR = 2.0 * CONST_A * Math.PI;
    private static final double HEIGHT_FACTOR = CONST_A * Math.PI;

    public Eckert3(int width, int height) {
        this(width, height, 0, 0);
    }

    public Eckert3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Eckert3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double diff;
        for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
        }
        while (diff < 0.0) {
            diff += 360.0;
        }
        if (Math.abs(diff - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot0 = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotN = this.transformLL2XY(lon, 90.0);
        Point2D.Double dotS = this.transformLL2XY(lon, -90.0);
        if (dot0 == null) {
            return;
        }
        double hw = dot0.x - dotN.x;
        double h = dotS.y - dotN.y;
        if (hw == 0.0) {
            GraphicUtilities.drawLine(g2d, dotN.x, dotN.y, dotS.x, dotS.y);
        } else if (hw > 0.0) {
            g2d.draw(new Arc2D.Double(dotN.x - hw, dotN.y, 2.0 * hw, h, -90.0, 180.0, 0));
        } else {
            g2d.draw(new Arc2D.Double(dot0.x, dotN.y, -2.0 * hw, h, 90.0, 180.0, 0));
        }
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = Eckert3.toRadians(lat);
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double x = CONST_A * lambdaRad * (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        double y = CONST_A * 2.0 * phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = y * 0.5 * this.oneOverRS_ * ONE_OVER_A;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double twoPhiOverPi = phiRad * 0.6366197723675814;
        double lambdaRad = x * ONE_OVER_A * this.oneOverRS_ / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Eckert3.toDegrees(phiRad);
        double lambda = Eckert3.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = (y = (double)iy + 0.5) * 0.5 * this.oneOverRS_ * ONE_OVER_A) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Eckert3.toDegrees(phiRad);
            double twoPhiOverPi = phiRad * 0.6366197723675814;
            double xFactor = ONE_OVER_A * this.oneOverRS_ / (1.0 + Math.sqrt(1.0 - twoPhiOverPi * twoPhiOverPi));
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Eckert3.toDegrees(lambdaRad), phi);
            }
        }
    }
}

