/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.text.TextUtilities;

public class DoubleParameter
extends ExtraParameter {
    private double value_;
    private double defaultValue_;
    private double min_;
    private double max_;
    private boolean minAllowed_ = true;
    private boolean maxAllowed_ = true;

    public DoubleParameter(String name, String units, double value) {
        this(name, units, value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true, true);
    }

    public DoubleParameter(String name, String units, double value, double min, double max) {
        this(name, units, value, min, max, true, true);
    }

    public DoubleParameter(String name, String units, double value, double min, double max, boolean minAllowed, boolean maxAllowed) {
        super(name, units);
        this.min_ = min;
        this.max_ = max;
        this.minAllowed_ = minAllowed;
        this.maxAllowed_ = maxAllowed;
        this.defaultValue_ = value;
        this.reset();
    }

    public void reset() {
        this.setValue(this.defaultValue_);
    }

    public double getDefault() {
        return this.defaultValue_;
    }

    public double getValue() {
        return this.value_;
    }

    public double getMinimum() {
        return this.min_;
    }

    public double getMaximum() {
        return this.max_;
    }

    public void setValue(double value) throws IllegalArgumentException {
        if (value < this.min_) {
            throw new IllegalArgumentException("Value less than minimum: " + value + " < " + this.min_);
        }
        if (value <= this.min_ && !this.minAllowed_) {
            throw new IllegalArgumentException("Value must be greater than minimum: " + value + " <= " + this.min_);
        }
        if (value > this.max_) {
            throw new IllegalArgumentException("Value greater than maximum: " + value + " > " + this.max_);
        }
        if (value >= this.max_ && !this.maxAllowed_) {
            throw new IllegalArgumentException("Value must be less than maximum: " + value + " >= " + this.max_);
        }
        this.value_ = value;
        this.fireChange();
    }

    public Object getDefaultObject() {
        return this.defaultValue_;
    }

    public Object getValueObject() {
        return this.value_;
    }

    public void setValue(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        try {
            double d = TextUtilities.parseDouble(value);
            this.setValue(d);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a Double: " + value);
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException("Value is not a Double: " + value);
        }
        this.setValue((Double)value);
    }
}

