/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Denoyer
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Denoyer Semi-Elliptical";
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public Denoyer(int width, int height) {
        this(width, height, 0, 0);
    }

    public Denoyer(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Denoyer(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Denoyer.toRadians(lat);
        double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
        double lambdaRad = this.lon2LambdaRad(lon);
        double absLRad = Math.abs(lambdaRad);
        double lambdaRad2 = absLRad * absLRad;
        double z = (0.95 + absLRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
        double x = lambdaRad * Math.cos(z);
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double phiRad = y * this.oneOverRS_;
        double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
        double xOverRS = x * this.oneOverRS_;
        double lambdaRad = 1.5707963267948966 * (x > 0.0 ? 1.0 : -1.0);
        for (int iter = 0; iter < 25; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double z = (0.95 + lambdaRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
            double dz = (-0.08333333333333333 + lambdaRad2 / 200.0) * phiTerm;
            double cosTerm = Math.cos(z);
            double dcosTerm = -Math.sin(z) * dz;
            double top = -(lambdaRad * cosTerm - xOverRS);
            double bottom = cosTerm + lambdaRad * dcosTerm;
            double dLambdaRad = top / bottom;
            lambdaRad += dLambdaRad;
            if (Math.abs(dLambdaRad) < 1.0E-5) break;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Denoyer.toDegrees(phiRad);
        double lambda = Denoyer.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double phiRad;
        double y;
        block0: for (int iy = 0; iy < this.yMax_ && !((y = (double)iy + 0.5) > this.ymRS_) && !((phiRad = y * this.oneOverRS_) > 1.5707963267948966); ++iy) {
            double phi = Denoyer.toDegrees(phiRad);
            double phiTerm = phiRad * (0.9 + 0.03 * phiRad * phiRad * phiRad * phiRad);
            double lambdaRad = 0.5;
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double x = (double)ix + 0.5;
                double xOverRS = x * this.oneOverRS_;
                for (int iter = 0; iter < 25; ++iter) {
                    double lambdaRad2 = lambdaRad * lambdaRad;
                    double z = (0.95 + lambdaRad * (-0.08333333333333333 + lambdaRad2 / 600.0)) * phiTerm;
                    double dz = (-0.08333333333333333 + lambdaRad2 / 200.0) * phiTerm;
                    double cosTerm = Math.cos(z);
                    double dcosTerm = -Math.sin(z) * dz;
                    double top = -(lambdaRad * cosTerm - xOverRS);
                    double bottom = cosTerm + lambdaRad * dcosTerm;
                    double dLambdaRad = top / bottom;
                    lambdaRad += dLambdaRad;
                    if (Math.abs(dLambdaRad) < 1.0E-5) break;
                }
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, Denoyer.toDegrees(lambdaRad), phi);
            }
        }
    }
}

