/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.CylindricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CylindricalEqualArea
extends CylindricProjection {
    public static final String PROJECTION_NAME = "Cylindrical Equal-Area";
    private static final double DEFAULT_PHITS = 30.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.0;
    private double cosPhiTS_ = Math.cos(CylindricalEqualArea.toRadians(30.0));
    private int lMargin_;
    private int rMargin_;
    private int tMargin_;
    private int bMargin_;

    public CylindricalEqualArea(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CylindricalEqualArea(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2, width, height, xmargin, ymargin, Math.PI, 1.0);
        this.addParameter(new DoubleParameter("Std. Parallel", "\u00b0", 30.0, 0.0, 90.0, true, false));
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            p = this.getParameter(0);
        } else if (p != this.getParameter(0)) {
            throw new IllegalArgumentException("Unknown parameter");
        }
        this.setStandardParallel(((DoubleParameter)p).getValue());
    }

    public void setStandardParallel(double lat) {
        this.cosPhiTS_ = Math.cos(CylindricalEqualArea.toRadians(lat));
        this.autoscale();
    }

    protected void prepareScaling() {
        double xMaxOverR = Math.PI * this.cosPhiTS_;
        double yMaxOverR = 1.0 / this.cosPhiTS_;
        this.setSizeFactors(xMaxOverR, yMaxOverR);
    }

    protected void finishScaling() {
        Dimension ms = this.getMarginSize();
        double trueWidth = ((double)this.outWidth_ - 2.0 * ms.getWidth()) * this.cosPhiTS_;
        double halfTrueWidth = 0.5 * trueWidth;
        this.lMargin_ = (int)((double)this.outCenterX_ - halfTrueWidth);
        this.rMargin_ = (int)((double)this.outCenterX_ + halfTrueWidth);
        this.tMargin_ = ms.height;
        this.bMargin_ = this.outHeight_ - ms.height;
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.cosPhiTS_ * this.lon2LambdaRad(lon);
        double y = Math.sin(CylindricalEqualArea.toRadians(lat)) / this.cosPhiTS_;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        double phiRad = Math.asin(y * this.cosPhiTS_ * this.oneOverRS_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.oneOverRS_ / this.cosPhiTS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = CylindricalEqualArea.toDegrees(phiRad);
        double lambda = CylindricalEqualArea.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad;
        double oneOverRScosPhiTS_ = this.oneOverRS_ / this.cosPhiTS_;
        for (int iy = 0; iy < this.yMax_ && !((phiRad = Math.asin((y = (double)iy + 0.5) * this.cosPhiTS_ * this.oneOverRS_)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = CylindricalEqualArea.toDegrees(phiRad);
            for (int ix = 0; ix < this.xMax_ && !((lambdaRad = (x = (double)ix + 0.5) * oneOverRScosPhiTS_) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, CylindricalEqualArea.toDegrees(lambdaRad), phi);
            }
        }
    }
}

