/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public abstract class CylindricProjection
extends QuadSymmetricProjection {
    public static final int PROPERTIES = 2;

    public CylindricProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    public boolean canLabelGrid() {
        return true;
    }

    protected void drawBorderLines(Graphics2D g2d) {
        BasicStroke bstroke;
        Stroke ostroke = g2d.getStroke();
        if (ostroke instanceof BasicStroke && ((bstroke = (BasicStroke)ostroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2d.setStroke(new BasicStroke(bstroke.getLineWidth(), 2, 0));
        }
        Path2D.Double path = new Path2D.Double();
        path.moveTo(this.outCenterX_ - this.xMax_, this.outCenterY_ - this.yMax_);
        path.lineTo(this.outCenterX_ - this.xMax_, this.outCenterY_ + this.yMax_);
        path.lineTo(this.outCenterX_ + this.xMax_, this.outCenterY_ + this.yMax_);
        path.lineTo(this.outCenterX_ + this.xMax_, this.outCenterY_ - this.yMax_);
        path.closePath();
        g2d.draw(path);
        g2d.setStroke(ostroke);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.lambdaC_ - 180.0 + 1.0E-5;
        double rlon = this.lambdaC_ + 180.0 - 1.0E-5;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        if (label == null) {
            GraphicUtilities.drawLine(g2d, dot1.x, dot1.y, dot2.x, dot1.y);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int a = fm.getAscent();
        float x = (float)(dot2.x - 3.0 - 2.0 - (double)w);
        GraphicUtilities.drawLine(g2d, dot1.x, dot1.y, (double)(x - 2.0f), dot1.y);
        GraphicUtilities.drawString(g2d, label, x, (float)(dot1.y + 0.5 * (double)a));
        GraphicUtilities.drawLine(g2d, (double)(x + (float)w + 2.0f), dot1.y, dot2.x, dot1.y);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double diff;
        for (diff = lon - this.lambdaC_; diff > 360.0; diff -= 360.0) {
        }
        while (diff < 0.0) {
            diff += 360.0;
        }
        if (Math.abs(diff - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dot = this.transformLL2XY(lon, 0.0);
        if (dot == null) {
            return;
        }
        float top = this.outCenterY_ - this.yMax_;
        float bottom = this.outCenterY_ + this.yMax_;
        if (label == null) {
            GraphicUtilities.drawLine(g2d, dot.x, (double)top, dot.x, (double)bottom);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int a = fm.getAscent();
        GraphicUtilities.drawLine(g2d, dot.x, (double)top, dot.x, (double)(bottom - 5.0f - (float)a));
        GraphicUtilities.drawString(g2d, label, (float)(dot.x - 0.5 * (double)w), (float)(dot.y + (double)this.yMax_ - 5.0 - 1.0));
        GraphicUtilities.drawLine(g2d, dot.x, (double)(bottom - 5.0f + 1.0f), dot.x, (double)bottom);
    }
}

