/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class CurvePoleProjection
extends QuadSymmetricProjection {
    public CurvePoleProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        this.makeBezier().paint(g2d);
    }

    private Bezier makeBezier() {
        Point2D.Double dot;
        double jj;
        int j;
        double edgeLon = this.lambdaC_ + 180.0 - 0.05;
        int np1 = 40;
        int np2 = 60;
        int np = 100;
        double np1fact = 1.5;
        double np2fact = 0.5;
        Point2D.Double[] dots = new Point2D.Double[401];
        for (j = 0; j < 40; ++j) {
            jj = 1.5 * (double)j;
            dot = this.transformLL2XY(edgeLon, jj);
            if (dot.x < (double)this.outCenterX_) {
                dot.x += 2.0 * ((double)this.outCenterX_ - dot.x);
            }
            dots[j] = new Point2D.Double(dot.x, dot.y);
            dots[200 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dots[200 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dots[400 - j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        for (j = 0; j <= 60; ++j) {
            jj = 60.0 + 0.5 * (double)j;
            dot = this.transformLL2XY(edgeLon, jj);
            if (dot.x < (double)this.outCenterX_) {
                dot.x += 2.0 * ((double)this.outCenterX_ - dot.x);
            }
            dots[40 + j] = new Point2D.Double(dot.x, dot.y);
            dots[200 - (40 + j)] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dots[200 + (40 + j)] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dots[400 - (40 + j)] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        return new Bezier(true, dots);
    }
}

