/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public abstract class ConicProjection
extends BiSymmetricProjection {
    protected static final double DEFAULT_PHI1 = 60.0;
    protected static final double DEFAULT_PHI2 = 30.0;
    protected static final double DEFAULT_HEIGHT = Math.abs(30.0);
    protected double phi1_ = 60.0;
    protected double phi2_ = 30.0;
    protected double phiHeight_ = 1.5 * Math.abs(30.0);
    private double lMargin_;
    private double rMargin_;
    private double tMargin_;
    private double bMargin_;
    private Point2D.Double coneTip_ = new Point2D.Double();
    private double coneOrientation_;
    private Arc2D.Double arc_;
    private Line2D.Double line_;
    private Rectangle2D.Double mapRect_;

    public ConicProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
        this.addParameter(new DoubleParameter("Std. Par. 1", "\u00b0N", 60.0, -90.0, 90.0, true, true));
        this.addParameter(new DoubleParameter("Std. Par. 2", "\u00b0N", 30.0, -90.0, 90.0, true, true));
        this.addParameter(new DoubleParameter("Height", "\u00b0", DEFAULT_HEIGHT, 0.002, 360.0, true, true));
        this.arc_ = new Arc2D.Double();
        this.line_ = new Line2D.Double();
        this.mapRect_ = new Rectangle2D.Double();
        this.autoscale();
    }

    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.autoscale();
    }

    public void parameterChanged(ProjParameterEvent e) {
        ExtraParameter p;
        ExtraParameter extraParameter = p = e == null ? null : (ExtraParameter)e.getSource();
        if (p == null) {
            this.setStandardParallels(((DoubleParameter)this.getParameter(0)).getValue(), ((DoubleParameter)this.getParameter(1)).getValue());
            this.setHeight(((DoubleParameter)this.getParameter(2)).getValue());
        } else if (p == this.getParameter(0) || p == this.getParameter(1)) {
            this.setStandardParallels(((DoubleParameter)this.getParameter(0)).getValue(), ((DoubleParameter)this.getParameter(1)).getValue());
        } else if (p == this.getParameter(2)) {
            this.setHeight(((DoubleParameter)p).getValue());
        }
    }

    public void setStandardParallels(double lat1, double lat2) {
        this.phi1_ = lat1;
        this.phi2_ = lat2;
        if (Math.abs(this.phi2_) > Math.abs(this.phi1_)) {
            double phiTemp = this.phi1_;
            this.phi1_ = this.phi2_;
            this.phi2_ = phiTemp;
        } else if (this.phi1_ + this.phi2_ == 0.0) {
            this.phi2_ *= 0.9999;
        }
        this.autoscale();
    }

    public void setHeight(double h) {
        this.phiHeight_ = h;
        this.autoscale();
    }

    private void setRect() {
        Dimension ms = this.getMarginSize();
        this.lMargin_ = ms.getWidth();
        this.rMargin_ = (double)this.outWidth_ - ms.getWidth();
        this.tMargin_ = ms.getHeight();
        this.bMargin_ = (double)this.outHeight_ - ms.getHeight();
        this.mapRect_.setFrameFromDiagonal(this.lMargin_, this.tMargin_, this.rMargin_, this.bMargin_);
    }

    protected void finishScaling() {
        this.findConeTip();
        this.findConeOrientation();
    }

    public void drawGrid(Graphics2D g2d, BasicStroke stroke, Color color) {
        if (this.coneOrientation_ == 0.0) {
            return;
        }
        this.setRect();
        super.drawGrid(g2d, stroke, color);
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        this.drawParallelX(g2d, lat);
    }

    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        this.drawMeridianX(g2d, lon);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        if (this.coneOrientation_ == 0.0) {
            return;
        }
        this.setRect();
        Vector clip1 = this.drawParallelX(g2d, 90.0);
        Vector clip2 = this.drawParallelX(g2d, -90.0);
        this.drawMeridianX(g2d, this.lambdaC_ + 179.995);
        Vector clip3 = this.drawMeridianX(g2d, this.lambdaC_ - 179.995);
        Vector clipPts = new Vector(24);
        if (clip1 != null) {
            clipPts.addAll(clip1);
        }
        if (clip2 != null) {
            clipPts.addAll(clip2);
        }
        if (clip3 != null) {
            clipPts.addAll(clip3);
        }
        for (int jj = 0; jj < 2; ++jj) {
            double ymargin = jj == 0 ? this.tMargin_ : this.bMargin_;
            Point2D.Double pt1 = null;
            Point2D.Double pt2 = null;
            PointLL ll = this.transformXY2LL(this.lMargin_, ymargin);
            if (ll != null) {
                pt1 = new Point2D.Double(this.lMargin_, ymargin);
            }
            for (int i = clipPts.size() - 1; i >= 0; --i) {
                Point2D.Double pt = (Point2D.Double)clipPts.elementAt(i);
                if (pt.y != ymargin) continue;
                if (pt1 == null) {
                    pt1 = pt;
                    clipPts.removeElementAt(i);
                    continue;
                }
                pt2 = pt;
                clipPts.removeElementAt(i);
                break;
            }
            if (pt1 != null && pt2 != null) {
                this.line_.setLine(pt1, pt2);
                g2d.draw(this.line_);
                pt1.x = (double)this.outCenterX_ + ((double)this.outCenterX_ - pt1.x);
                pt2.x = (double)this.outCenterX_ + ((double)this.outCenterX_ - pt2.x);
                this.line_.setLine(pt1, pt2);
                g2d.draw(this.line_);
                continue;
            }
            if (pt1 == null) continue;
            pt2 = new Point2D.Double((double)this.outCenterX_ + ((double)this.outCenterX_ - pt1.x), pt1.y);
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
        }
        Point2D.Double pt1 = null;
        Point2D.Double pt2 = null;
        PointLL ll = this.transformXY2LL(this.lMargin_, this.tMargin_);
        if (ll != null) {
            pt1 = new Point2D.Double(this.lMargin_, this.tMargin_);
        }
        for (int i = clipPts.size() - 1; i >= 0; --i) {
            Point2D.Double pt = (Point2D.Double)clipPts.elementAt(i);
            if (pt1 != null) {
                pt2 = pt;
                clipPts.removeElementAt(i);
                break;
            }
            pt1 = pt;
            clipPts.removeElementAt(i);
        }
        if (pt1 != null && pt2 != null) {
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
            pt1.x = this.rMargin_;
            pt2.x = this.rMargin_;
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
        } else if (pt1 != null) {
            pt2 = new Point2D.Double(this.lMargin_, this.bMargin_);
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
            pt1.x = this.rMargin_;
            pt2.x = this.rMargin_;
            this.line_.setLine(pt1, pt2);
            g2d.draw(this.line_);
        }
    }

    private Vector drawMeridianX(Graphics2D g2d, double lon) {
        Point2D.Double np = this.transformLL2XYIgnoreMargins(lon, 90.0);
        Point2D.Double sp = this.transformLL2XYIgnoreMargins(lon, -90.0);
        if (np == null) {
            np = this.transformLL2XYIgnoreMargins(lon, 89.975);
        }
        if (sp == null) {
            sp = this.transformLL2XYIgnoreMargins(lon, -89.975);
        }
        if (np == null || sp == null) {
            return null;
        }
        this.line_.setLine(np, sp);
        if (!this.line_.intersects(this.mapRect_)) {
            return null;
        }
        Vector<Object> clipPts = new Vector<Object>(12);
        Point2D.Double[] pts = new Point2D.Double[]{np, sp};
        double dx = pts[1].x - pts[0].x;
        if (dx == 0.0) {
            for (int k = 0; k < 2; ++k) {
                if (pts[k].y < this.tMargin_) {
                    pts[k].y = this.tMargin_;
                    clipPts.add(pts[k].clone());
                }
                if (!(pts[k].y > this.bMargin_)) continue;
                pts[k].y = this.bMargin_;
                clipPts.add(pts[k].clone());
            }
        } else {
            double dy = pts[1].y - pts[0].y;
            double slope = dy / dx;
            for (int k = 0; k < 2; ++k) {
                double dyy;
                double dxx;
                if (pts[k].x < this.lMargin_) {
                    dxx = this.lMargin_ - pts[k].x;
                    pts[k].x = this.lMargin_;
                    pts[k].y += slope * dxx;
                    clipPts.add(pts[k].clone());
                } else if (pts[k].x > this.rMargin_) {
                    dxx = this.rMargin_ - pts[k].x;
                    pts[k].x = this.rMargin_;
                    pts[k].y += slope * dxx;
                    clipPts.add(pts[k].clone());
                }
                if (pts[k].y < this.tMargin_) {
                    dyy = this.tMargin_ - pts[k].y;
                    pts[k].x += dyy / slope;
                    pts[k].y = this.tMargin_;
                    clipPts.add(pts[k].clone());
                    continue;
                }
                if (!(pts[k].y > this.bMargin_)) continue;
                dyy = this.bMargin_ - pts[k].y;
                pts[k].x += dyy / slope;
                pts[k].y = this.bMargin_;
                clipPts.add(pts[k].clone());
            }
        }
        if (Math.abs(pts[1].x - pts[0].x) < 1.0E-5 && Math.abs(pts[1].y - pts[0].y) < 1.0E-5) {
            return null;
        }
        this.line_.setLine(pts[0], pts[1]);
        g2d.draw(this.line_);
        for (int i = clipPts.size() - 1; i >= 0; --i) {
            Point2D.Double pt2 = (Point2D.Double)clipPts.elementAt(i);
            if (!(pt2.x < this.lMargin_) && !(pt2.y < this.tMargin_) && !(pt2.y > this.bMargin_)) continue;
            clipPts.removeElementAt(i);
        }
        return clipPts;
    }

    private Vector drawParallelX(Graphics2D g2d, double lat) {
        Point2D.Double pt2;
        double dxx;
        double dyy;
        Point2D.Double pt = this.transformLL2XYIgnoreMargins(this.lambdaC_, lat);
        if (pt == null) {
            return null;
        }
        double radius = Math.abs(pt.y - this.coneTip_.y);
        if (radius < 1.0E-5) {
            return null;
        }
        double radius2 = radius * radius;
        Point2D.Double coneTipZ = (Point2D.Double)this.coneTip_.clone();
        if (this.coneOrientation_ < 0.0) {
            coneTipZ.y = (double)this.outCenterY_ + ((double)this.outCenterY_ - coneTipZ.y);
        }
        double baseRotate = this.coneOrientation_ < 0.0 ? 90.0 : 270.0;
        double dx = coneTipZ.x - this.lMargin_;
        double dyt = this.tMargin_ - coneTipZ.y;
        double dyb = this.bMargin_ - coneTipZ.y;
        double dx2 = dx * dx;
        double dyt2 = dyt * dyt;
        double dyb2 = dyb * dyb;
        if (coneTipZ.y + radius <= this.tMargin_) {
            return null;
        }
        if (coneTipZ.y <= this.tMargin_ && radius2 > dx2 + dyb2) {
            return null;
        }
        pt = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 180.0, lat);
        if (this.coneOrientation_ < 0.0) {
            pt.y = (double)this.outCenterY_ + ((double)this.outCenterY_ - pt.y);
        }
        if (pt.y > this.bMargin_) {
            return null;
        }
        Vector<Object> clipPts = new Vector<Object>(12);
        if (pt.y < this.tMargin_) {
            double dxx2 = Math.sqrt(radius2 - dyt2);
            pt.x = coneTipZ.x - dxx2;
            pt.y = this.tMargin_;
            clipPts.add(pt.clone());
        }
        if (pt.y < coneTipZ.y && pt.x <= this.lMargin_) {
            pt.x = coneTipZ.x - radius;
            pt.y = coneTipZ.y;
            clipPts.add(pt.clone());
        }
        double startAngle = 180.0;
        if (pt.y >= coneTipZ.y) {
            if (radius2 > dx2 + dyb2) {
                return null;
            }
            if (pt.x < this.lMargin_) {
                dyy = Math.sqrt(radius2 - dx2);
                pt.x = this.lMargin_;
                pt.y = coneTipZ.y + dyy;
                clipPts.add(pt.clone());
                startAngle = Math.asin(dx / radius) * 57.29577951308232;
            } else {
                dxx = coneTipZ.x - pt.x;
                startAngle = Math.asin(dxx / radius) * 57.29577951308232;
            }
        } else {
            startAngle = 180.0 - Math.asin((coneTipZ.x - pt.x) / radius) * 57.29577951308232;
            if (coneTipZ.x - radius < this.lMargin_) {
                dyy = Math.sqrt(radius2 - dx2);
                double anAngle = Math.asin(dx / radius) * 57.29577951308232;
                double breakAngle = 180.0 - anAngle;
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate - startAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate + breakAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
                pt.x = this.lMargin_;
                pt.y = coneTipZ.y - dyy;
                clipPts.add(pt.clone());
                pt.x = this.lMargin_;
                pt.y = coneTipZ.y + dyy;
                clipPts.add(pt.clone());
                startAngle = anAngle;
            }
        }
        if (pt.y < this.bMargin_) {
            if (dyb < radius) {
                dxx = Math.sqrt(radius2 - dyb2);
                pt.x = coneTipZ.x - dxx;
                pt.y = this.bMargin_;
                clipPts.add(pt.clone());
                double breakAngle = Math.acos(dyb / radius) * 57.29577951308232;
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate - startAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate + breakAngle, startAngle - breakAngle, 0);
                g2d.draw(this.arc_);
            } else {
                this.arc_.setArcByCenter(this.coneTip_.x, this.coneTip_.y, radius, baseRotate - startAngle, 2.0 * startAngle, 0);
                g2d.draw(this.arc_);
            }
        }
        if (this.coneOrientation_ < 0.0) {
            for (int i = clipPts.size() - 1; i >= 0; --i) {
                pt2 = (Point2D.Double)clipPts.elementAt(i);
                clipPts.removeElementAt(i);
                pt2.y = (double)this.outCenterY_ + ((double)this.outCenterY_ - pt2.y);
                clipPts.insertElementAt(pt2, i);
            }
        }
        for (int i = clipPts.size() - 1; i >= 0; --i) {
            pt2 = (Point2D.Double)clipPts.elementAt(i);
            if (!(pt2.x < this.lMargin_) && !(pt2.y < this.tMargin_) && !(pt2.y > this.bMargin_)) continue;
            clipPts.removeElementAt(i);
        }
        return clipPts;
    }

    private void findConeOrientation() {
        double phiSum = this.phi1_ + this.phi2_;
        this.coneOrientation_ = phiSum > 0.0 ? 90.0 : (phiSum < 0.0 ? -90.0 : 0.0);
    }

    private void findConeTip() {
        double sideB;
        this.findConeOrientation();
        if (this.coneOrientation_ == 0.0) {
            this.coneTip_ = null;
            return;
        }
        Point2D.Double ptA = this.transformLL2XYIgnoreMargins(this.lambdaC_, this.coneOrientation_);
        Point2D.Double ptB = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 180.0, this.coneOrientation_);
        double dxB = Math.abs(ptB.x - ptA.x);
        double dyB = Math.abs(ptB.y - ptA.y);
        if (dxB < 1.0E-5 && dyB < 1.0E-5) {
            this.coneTip_ = ptA;
            return;
        }
        if (dxB < 1.0E-5) {
            this.coneTip_.x = ptA.x;
            this.coneTip_.y = this.coneOrientation_ > 0.0 ? ptA.y - 0.5 * dyB : ptA.y + 0.5 * dyB;
            return;
        }
        if (dyB < 1.0E-5) {
            this.coneTip_.x = ptA.x;
            this.coneTip_.y = this.coneOrientation_ > 0.0 ? ptA.y - dxB : ptA.y + dxB;
            return;
        }
        double sideA = 2.0 * Math.abs(dxB);
        double sideC = sideB = Math.hypot(dxB, dyB);
        double s = 0.5 * (sideA + sideB + sideC);
        double angleARad = 2.0 * Math.asin((s - sideB) / sideB);
        double radius = 0.5 * sideA / Math.sin(angleARad);
        this.coneTip_.x = ptA.x;
        this.coneTip_.y = this.coneOrientation_ > 0.0 ? ptA.y - radius : ptA.y + radius;
    }
}

