/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class ConcavePoleProjection
extends QuadSymmetricProjection {
    private Bezier[] curves = new Bezier[4];

    public ConcavePoleProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double xMaxOverR, double yMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, xMaxOverR, yMaxOverR);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        this.makeOuterBezier();
        this.makePoleBezier();
        if (this.curves[0] != null) {
            this.curves[0].paint(g2d);
        }
        if (this.curves[1] != null) {
            this.curves[1].paint(g2d);
        }
        if (this.curves[2] != null) {
            this.curves[2].paint(g2d);
        }
        if (this.curves[3] != null) {
            this.curves[3].paint(g2d);
        }
    }

    protected void makeOuterBezier() {
        this.curves[0] = null;
        this.curves[1] = null;
        double edgeLon = this.lambdaC_ + 180.0 - 0.05;
        int np = 105;
        double fact = 0.8571428571428571;
        Point2D.Double[] dotsE = new Point2D.Double[211];
        Point2D.Double[] dotsW = new Point2D.Double[211];
        for (int j = 0; j <= 105; ++j) {
            double jj = 0.8571428571428571 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            if (dot == null) {
                System.err.println("WARNING: Null outer border point");
                return;
            }
            dotsE[105 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[105 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsW[105 - j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsW[105 + j] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        this.curves[0] = new Bezier(false, dotsE);
        this.curves[1] = new Bezier(false, dotsW);
    }

    protected void makePoleBezier() {
        this.curves[2] = null;
        this.curves[3] = null;
        int np = 45;
        double npfact = 4.0;
        Point2D.Double[] dotsN = new Point2D.Double[91];
        Point2D.Double[] dotsS = new Point2D.Double[91];
        for (int i = 0; i <= 45; ++i) {
            Point2D.Double dot;
            double ii = 4.0 * (double)i;
            if (i == 45) {
                ii -= 0.1;
            }
            if ((dot = this.transformLL2XY(this.lambdaC_ + ii, 90.0)) == null) {
                System.err.println("WARNING: Null pole border point");
                return;
            }
            dotsN[45 - i] = new Point2D.Double(dot.x, dot.y);
            dotsN[45 + i] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, dot.y);
            dotsS[45 - i] = new Point2D.Double(dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
            dotsS[45 + i] = new Point2D.Double(2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
        }
        this.curves[2] = new Bezier(false, dotsN);
        this.curves[3] = new Bezier(false, dotsS);
    }
}

