/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class CantersPseudocylindric2002f523
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Canters Pseudocylindric 2002 f5.23";
    private static final double C0 = 0.8333;
    private static final double C2 = 0.3385;
    private static final double C4 = 0.0942;
    private static final double C1P = 1.0114;
    private static final double C3P = 0.0243;
    private static final double C5P = -0.0391;
    private static final double THREE_C3P = 0.07289999999999999;
    private static final double FIVE_C5P = -0.1955;
    private static final double WIDTH_FACTOR = 2.6178891582363746;
    private static final double HEIGHT_FACTOR = 1.3089671679897534;

    public CantersPseudocylindric2002f523(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPseudocylindric2002f523(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CantersPseudocylindric2002f523(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.6178891582363746, 1.3089671679897534);
    }

    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawCurveBorder(g2d, this, this.outCenterX_, this.outCenterY_);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = CantersPseudocylindric2002f523.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * Math.cos(phiRad) * (0.8333 + phiRad2 * (0.3385 + phiRad2 * 0.0942));
        double y = phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double dphiRad = -(phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391)) - yOverRS) / (1.0114 + phiRad2 * (0.07289999999999999 + phiRad2 * -0.1955));
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double xFactor = this.oneOverRS_ / ((0.8333 + phiRad2 * (0.3385 + phiRad2 * 0.0942)) * Math.cos(phiRad));
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : x * xFactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = CantersPseudocylindric2002f523.toDegrees(phiRad);
        double lambda = CantersPseudocylindric2002f523.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad = 0.0;
        block0: for (int iy = 0; iy < this.yMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
            double phiRad2;
            double yOverRS = y * this.oneOverRS_;
            phiRad += 1.0E-5;
            for (int iter = 0; iter < 25; ++iter) {
                phiRad2 = phiRad * phiRad;
                double dphiRad = -(phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391)) - yOverRS) / (1.0114 + phiRad2 * (0.07289999999999999 + phiRad2 * -0.1955));
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = CantersPseudocylindric2002f523.toDegrees(phiRad);
            phiRad2 = phiRad * phiRad;
            double xFactor = this.oneOverRS_ / ((0.8333 + phiRad2 * (0.3385 + phiRad2 * 0.0942)) * Math.cos(phiRad));
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad;
                double x = (double)ix + 0.5;
                double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : x * xFactor;
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, CantersPseudocylindric2002f523.toDegrees(lambdaRad), phi);
            }
        }
    }
}

