/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.PseudocylindricProjection;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CantersPseudocylindric2002f520
extends PseudocylindricProjection {
    public static final String PROJECTION_NAME = "Canters Pseudocylindric 2002 f5.20";
    private static final double C0 = 0.8378;
    private static final double C2 = -0.1053;
    private static final double C4 = -0.0011;
    private static final double C1P = 1.015;
    private static final double C3P = 0.0207;
    private static final double C5P = -0.0375;
    private static final double THREE_C3P = 0.0621;
    private static final double FIVE_C5P = -0.1875;
    private static final double WIDTH_FACTOR = 2.6320263251775287;
    private static final double HEIGHT_FACTOR = 1.3159701944993438;

    public CantersPseudocylindric2002f520(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPseudocylindric2002f520(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public CantersPseudocylindric2002f520(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, 2.6320263251775287, 1.3159701944993438);
    }

    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.lon2LambdaRad(lon);
        double phiRad = CantersPseudocylindric2002f520.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * (0.8378 + phiRad2 * (-0.1053 + phiRad2 * -0.0011));
        double y = phiRad * (1.015 + phiRad2 * (0.0207 + phiRad2 * -0.0375));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.xMax_ || Math.abs(y) > (double)this.yMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.oneOverRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 25; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double dphiRad = -(phiRad * (1.015 + phiRad2 * (0.0207 + phiRad2 * -0.0375)) - yOverRS) / (1.015 + phiRad2 * (0.0621 + phiRad2 * -0.1875));
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double xFactor = this.oneOverRS_ / (0.8378 + phiRad2 * (-0.1053 + phiRad2 * -0.0011));
        double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : x * xFactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = CantersPseudocylindric2002f520.toDegrees(phiRad);
        double lambda = CantersPseudocylindric2002f520.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    protected synchronized void calculateInverseArray() {
        double y;
        double phiRad = 0.0;
        block0: for (int iy = 0; iy < this.yMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
            double phiRad2;
            double yOverRS = y * this.oneOverRS_;
            phiRad += 1.0E-5;
            for (int iter = 0; iter < 25; ++iter) {
                phiRad2 = phiRad * phiRad;
                double dphiRad = -(phiRad * (1.015 + phiRad2 * (0.0207 + phiRad2 * -0.0375)) - yOverRS) / (1.015 + phiRad2 * (0.0621 + phiRad2 * -0.1875));
                phiRad += dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double phi = CantersPseudocylindric2002f520.toDegrees(phiRad);
            phiRad2 = phiRad * phiRad;
            double xFactor = this.oneOverRS_ / (0.8378 + phiRad2 * (-0.1053 + phiRad2 * -0.0011));
            for (int ix = 0; ix < this.xMax_; ++ix) {
                double lambdaRad;
                double x = (double)ix + 0.5;
                double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : x * xFactor;
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, CantersPseudocylindric2002f520.toDegrees(lambdaRad), phi);
            }
        }
    }
}

